/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Collector;
import org.apache.jasper.compiler.ELFunctionMapper;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ScriptingVariabler;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.compiler.TextOptimizer;
import org.apache.jasper.compiler.Validator;
import org.apache.jasper.servlet.JspServletWrapper;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class Compiler {
    protected Log log = LogFactory.getLog(Compiler.class);
    protected JspCompilationContext ctxt;
    protected ErrorDispatcher errDispatcher;
    protected PageInfo pageInfo;
    protected JspServletWrapper jsw;
    protected TagFileProcessor tfp;
    protected Options options;
    protected Node.Nodes pageNodes;

    public void init(JspCompilationContext ctxt, JspServletWrapper jsw) {
        this.jsw = jsw;
        this.ctxt = ctxt;
        this.options = ctxt.getOptions();
    }

    public Node.Nodes getPageNodes() {
        return this.pageNodes;
    }

    protected String[] generateJava() throws Exception {
        String[] smapStr = null;
        long t4 = 0L;
        long t3 = 0L;
        long t2 = 0L;
        long t1 = 0L;
        if (this.log.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        this.pageInfo = new PageInfo(new BeanRepository(this.ctxt.getClassLoader(), this.errDispatcher), this.ctxt.getJspFile());
        JspConfig jspConfig = this.options.getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(this.ctxt.getJspFile());
        if (jspProperty.isELIgnored() != null) {
            this.pageInfo.setELIgnored(JspUtil.booleanValue(jspProperty.isELIgnored()));
        }
        if (jspProperty.isScriptingInvalid() != null) {
            this.pageInfo.setScriptingInvalid(JspUtil.booleanValue(jspProperty.isScriptingInvalid()));
        }
        if (jspProperty.getIncludePrelude() != null) {
            this.pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
        }
        if (jspProperty.getIncludeCoda() != null) {
            this.pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
        }
        if (jspProperty.isDeferedSyntaxAllowedAsLiteral() != null) {
            this.pageInfo.setDeferredSyntaxAllowedAsLiteral(JspUtil.booleanValue(jspProperty.isDeferedSyntaxAllowedAsLiteral()));
        }
        if (jspProperty.isTrimDirectiveWhitespaces() != null) {
            this.pageInfo.setTrimDirectiveWhitespaces(JspUtil.booleanValue(jspProperty.isTrimDirectiveWhitespaces()));
        }
        this.ctxt.checkOutputDir();
        String javaFileName = this.ctxt.getServletJavaFileName();
        ServletWriter writer = null;
        try {
            String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
            }
            catch (UnsupportedEncodingException ex) {
                this.errDispatcher.jspError("jsp.error.needAlternateJavaEncoding", javaEncoding);
            }
            writer = new ServletWriter(new PrintWriter(osw));
            this.ctxt.setWriter(writer);
            JspUtil.resetTemporaryVariableName();
            ParserController parserCtl = new ParserController(this.ctxt, this);
            this.pageNodes = parserCtl.parse(this.ctxt.getJspFile());
            if (this.ctxt.isPrototypeMode()) {
                Generator.generate(writer, this, this.pageNodes);
                writer.close();
                writer = null;
                String[] stringArray = null;
                return stringArray;
            }
            Validator.validate(this, this.pageNodes);
            if (this.log.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
            }
            Collector.collect(this, this.pageNodes);
            this.tfp = new TagFileProcessor();
            this.tfp.loadTagFiles(this, this.pageNodes);
            if (this.log.isDebugEnabled()) {
                t3 = System.currentTimeMillis();
            }
            ScriptingVariabler.set(this.pageNodes, this.errDispatcher);
            TagPluginManager tagPluginManager = this.options.getTagPluginManager();
            tagPluginManager.apply(this.pageNodes, this.errDispatcher, this.pageInfo);
            TextOptimizer.concatenate(this, this.pageNodes);
            ELFunctionMapper.map(this, this.pageNodes);
            Generator.generate(writer, this, this.pageNodes);
            writer.close();
            writer = null;
            this.ctxt.setWriter(null);
            if (this.log.isDebugEnabled()) {
                t4 = System.currentTimeMillis();
                this.log.debug((Object)("Generated " + javaFileName + " total=" + (t4 - t1) + " generate=" + (t4 - t3) + " validate=" + (t2 - t1)));
            }
        }
        catch (Exception e) {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            new File(javaFileName).delete();
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e2) {}
            }
        }
        if (!this.options.isSmapSuppressed()) {
            smapStr = SmapUtil.generateSmap(this.ctxt, this.pageNodes);
        }
        this.tfp.removeProtoTypeFiles(this.ctxt.getClassFileName());
        return smapStr;
    }

    protected abstract void generateClass(String[] var1) throws FileNotFoundException, JasperException, Exception;

    public void compile() throws FileNotFoundException, JasperException, Exception {
        this.compile(true);
    }

    public void compile(boolean compileClass) throws FileNotFoundException, JasperException, Exception {
        this.compile(compileClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compile(boolean compileClass, boolean jspcMode) throws FileNotFoundException, JasperException, Exception {
        if (this.errDispatcher == null) {
            this.errDispatcher = new ErrorDispatcher(jspcMode);
        }
        try {
            String[] smap = this.generateJava();
            if (compileClass) {
                this.generateClass(smap);
            }
            Object var5_4 = null;
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.pageInfo = null;
            if (!this.options.getDevelopment()) {
                this.pageNodes = null;
            }
            if (this.ctxt.getWriter() == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.pageInfo = null;
            if (!this.options.getDevelopment()) {
                this.pageNodes = null;
            }
            if (this.ctxt.getWriter() == null) throw throwable;
            this.ctxt.getWriter().close();
            this.ctxt.setWriter(null);
            throw throwable;
        }
        this.ctxt.getWriter().close();
        this.ctxt.setWriter(null);
    }

    public boolean isOutDated() {
        return this.isOutDated(true);
    }

    public boolean isOutDated(boolean checkClass) {
        String jsp = this.ctxt.getJspFile();
        if (this.jsw != null && this.ctxt.getOptions().getModificationTestInterval() > 0) {
            if (this.jsw.getLastModificationTest() + (long)(this.ctxt.getOptions().getModificationTestInterval() * 1000) > System.currentTimeMillis()) {
                return false;
            }
            this.jsw.setLastModificationTest(System.currentTimeMillis());
        }
        long jspRealLastModified = 0L;
        try {
            URL jspUrl = this.ctxt.getResource(jsp);
            if (jspUrl == null) {
                this.ctxt.incrementRemoved();
                return false;
            }
            URLConnection uc = jspUrl.openConnection();
            jspRealLastModified = uc.getLastModified();
            uc.getInputStream().close();
        }
        catch (Exception e) {
            return true;
        }
        long targetLastModified = 0L;
        File targetFile = checkClass ? new File(this.ctxt.getClassFileName()) : new File(this.ctxt.getServletJavaFileName());
        if (!targetFile.exists()) {
            return true;
        }
        targetLastModified = targetFile.lastModified();
        if (checkClass && this.jsw != null) {
            this.jsw.setServletClassLastModifiedTime(targetLastModified);
        }
        if (targetLastModified < jspRealLastModified) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Compiler: outdated: " + targetFile + " " + targetLastModified));
            }
            return true;
        }
        if (this.jsw == null) {
            return false;
        }
        List depends = this.jsw.getDependants();
        if (depends == null) {
            return false;
        }
        for (String include : depends) {
            try {
                URL includeUrl = this.ctxt.getResource(include);
                if (includeUrl == null) {
                    return true;
                }
                URLConnection includeUconn = includeUrl.openConnection();
                long includeLastModified = includeUconn.getLastModified();
                includeUconn.getInputStream().close();
                if (includeLastModified <= targetLastModified) continue;
                return true;
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public JspCompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Deleting " + classFile));
                }
                classFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String javaFileName = this.ctxt.getServletJavaFileName();
            if (javaFileName != null) {
                File javaFile = new File(javaFileName);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Deleting " + javaFile));
                }
                javaFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeGeneratedClassFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Deleting " + classFile));
                }
                classFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

