/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import org.hibernate.MappingException;
import org.hibernate.property.Setter;
import org.jboss.envers.RevisionListener;
import org.jboss.envers.configuration.RevisionInfoGenerator;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomRevisionInfoGenerator
implements RevisionInfoGenerator {
    private RevisionListener listener;
    private Setter revisionTimestampSetter;
    private Class<?> entityClass;

    public CustomRevisionInfoGenerator(VersionsEntitiesConfiguration verEntCfg, Class<?> entityClass, Class<? extends RevisionListener> listenerClass) {
        this.entityClass = entityClass;
        this.revisionTimestampSetter = ReflectionTools.getSetter(entityClass, verEntCfg.getRevisionsInfoTimestampName());
        if (!listenerClass.equals(RevisionListener.class)) {
            try {
                this.listener = listenerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MappingException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MappingException((Throwable)e);
            }
        }
    }

    @Override
    public Object newRevision() {
        Object entity;
        try {
            entity = this.entityClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.revisionTimestampSetter.set(entity, (Object)System.currentTimeMillis(), null);
        if (this.listener != null) {
            this.listener.newRevision(entity);
        }
        return entity;
    }
}

