/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.PersistentClass;
import org.jboss.envers.configuration.EntitiesConfigurations;
import org.jboss.envers.configuration.EntityConfiguration;
import org.jboss.envers.configuration.PersistentClassGraphDefiner;
import org.jboss.envers.configuration.RelationDescription;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.mapper.ExtendedPropertyMapper;
import org.jboss.envers.mapper.id.IdMapper;
import org.jboss.envers.metadata.AnnotationsMetadataReader;
import org.jboss.envers.metadata.RevisionsInfoMetadataGenerator;
import org.jboss.envers.metadata.VersionsMetadataGenerator;
import org.jboss.envers.metadata.data.PersistentClassVersioningData;
import org.jboss.envers.reflection.YReflectionManager;
import org.jboss.envers.synchronization.VersionsSyncManager;
import org.jboss.envers.tools.graph.GraphTopologicalSort;

public class VersionsConfiguration {
    private VersionsEntitiesConfiguration verEntCfg;
    private VersionsSyncManager versionsSyncManager;
    private EntitiesConfigurations entitiesConfigurations;
    private boolean generateRevisionsForCollections;
    private boolean warnOnUnsupportedTypes;
    private static Map<Configuration, VersionsConfiguration> cfgs = new WeakHashMap<Configuration, VersionsConfiguration>();

    public VersionsEntitiesConfiguration getEntitiesCfg() {
        return this.verEntCfg;
    }

    public VersionsSyncManager getSyncManager() {
        return this.versionsSyncManager;
    }

    private void writeDocument(Document e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter w = new PrintWriter(baos);
        try {
            XMLWriter xw = new XMLWriter((Writer)w, new OutputFormat(" ", true));
            xw.write(e);
            ((Writer)w).flush();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println("-----------");
        System.out.println(baos.toString());
        System.out.println("-----------");
    }

    private YReflectionManager getReflectionManager(Configuration cfg) {
        try {
            return new YReflectionManager(cfg);
        }
        catch (Exception e) {
            throw new MappingException((Throwable)e);
        }
    }

    private boolean isVersioned(PersistentClassVersioningData versioningData) {
        if (versioningData == null) {
            return false;
        }
        if (versioningData.propertyStoreInfo.propertyStores.size() > 0) {
            return true;
        }
        return versioningData.propertyStoreInfo.defaultStore != null;
    }

    private void configureFromProperties(Properties properties) {
        String generateRevisionsForCollectionsStr = properties.getProperty("org.jboss.envers.revisionOnCollectionChange", "true");
        this.generateRevisionsForCollections = Boolean.parseBoolean(generateRevisionsForCollectionsStr);
        String warnOnUnsupportedTypesStr = properties.getProperty("org.jboss.envers.warnOnUnsupportedTypes", "false");
        this.warnOnUnsupportedTypes = Boolean.parseBoolean(warnOnUnsupportedTypesStr);
    }

    public void configure(Configuration cfg) {
        this.configureFromProperties(cfg.getProperties());
        YReflectionManager reflectionManager = this.getReflectionManager(cfg);
        this.verEntCfg = VersionsEntitiesConfiguration.get(cfg, reflectionManager);
        this.versionsSyncManager = new VersionsSyncManager(this.verEntCfg);
        VersionsMetadataGenerator versionsMetaGen = new VersionsMetadataGenerator(this, this.verEntCfg);
        DOMWriter writer = new DOMWriter();
        Iterator<PersistentClass> classes = GraphTopologicalSort.sort(new PersistentClassGraphDefiner(cfg)).iterator();
        HashMap<PersistentClass, PersistentClassVersioningData> pcDatas = new HashMap<PersistentClass, PersistentClassVersioningData>();
        HashMap<PersistentClass, Document> documents = new HashMap<PersistentClass, Document>();
        AnnotationsMetadataReader annotationsMetadataReader = new AnnotationsMetadataReader();
        while (classes.hasNext()) {
            PersistentClass pc = classes.next();
            PersistentClassVersioningData versioningData = annotationsMetadataReader.getVersioningData(pc, reflectionManager);
            if (!this.isVersioned(versioningData)) continue;
            pcDatas.put(pc, versioningData);
            if (versioningData.versionsTableName != null) {
                this.verEntCfg.addCustomVersionsTableName(pc.getEntityName(), versioningData.versionsTableName);
            }
            Document genData = versionsMetaGen.generateFirstPass(pc, versioningData);
            documents.put(pc, genData);
        }
        for (PersistentClass pc : pcDatas.keySet()) {
            Document document = (Document)documents.get(pc);
            versionsMetaGen.generateSecondPass(pc, (PersistentClassVersioningData)pcDatas.get(pc), document);
            try {
                cfg.addDocument(writer.write(document));
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
        this.entitiesConfigurations = new EntitiesConfigurations(versionsMetaGen.getEntitiesConfigurations());
        if (this.entitiesConfigurations.get(this.verEntCfg.getRevisionsInfoEntityName()) != null) {
            throw new MappingException("An entity annotated with @RevisionEntity cannot be versioned!");
        }
        if (pcDatas.size() > 0) {
            try {
                if (!this.verEntCfg.hasCustomRevisionInfoEntity()) {
                    RevisionsInfoMetadataGenerator revisionsMetaGenInfo = new RevisionsInfoMetadataGenerator(this.verEntCfg);
                    Document helperEntity = revisionsMetaGenInfo.generate();
                    cfg.addDocument(writer.write(helperEntity));
                }
            }
            catch (DocumentException e) {
                throw new MappingException((Throwable)e);
            }
        }
    }

    public boolean isVersioned(String entityName) {
        return this.entitiesConfigurations.get(entityName) != null;
    }

    public IdMapper getIdMapper(String entityName) {
        return this.entitiesConfigurations.get(entityName).getIdMappingData().getIdMapper();
    }

    public ExtendedPropertyMapper getPropertyMapper(String entityName) {
        return this.entitiesConfigurations.get(entityName).getPropertyMapper();
    }

    public EntityConfiguration getEntityConfiguration(String entityName) {
        return this.entitiesConfigurations.get(entityName);
    }

    public String getEntityNameForVersionsEntityName(String versionsEntityName) {
        return this.entitiesConfigurations.getEntityNameForVersionsEntityName(versionsEntityName);
    }

    public boolean isGenerateRevisionsForCollections() {
        return this.generateRevisionsForCollections;
    }

    public boolean isWarnOnUnsupportedTypes() {
        return this.warnOnUnsupportedTypes;
    }

    public RelationDescription getRelationDescription(String entityName, String propertyName) {
        return this.entitiesConfigurations.getRelationDescription(entityName, propertyName);
    }

    public static synchronized VersionsConfiguration getFor(Configuration cfg) {
        VersionsConfiguration verCfg = cfgs.get(cfg);
        if (verCfg == null) {
            verCfg = new VersionsConfiguration();
            cfgs.put(cfg, verCfg);
            verCfg.configure(cfg);
            cfg.buildMappings();
        }
        return verCfg;
    }
}

