/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.entity;

import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.cache.CacheConcurrencyStrategy;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.Mapping;
import org.hibernate.HibernateException;
import org.hibernate.EntityMode;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class VersionsInheritanceEntityPersisterFor32 extends SingleTableEntityPersister {
    public VersionsInheritanceEntityPersisterFor32(PersistentClass persistentClass, CacheConcurrencyStrategy cache, SessionFactoryImplementor factory, Mapping mapping) throws HibernateException {
        super(persistentClass, cache, factory, mapping);
    }

    // A hack for http://opensource.atlassian.com/projects/hibernate/browse/HHH-3351
    public EntityPersister getSubclassEntityPersister(Object instance, SessionFactoryImplementor factory, EntityMode entityMode) {
        return this;
    }
}