/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.configuration;

import org.jboss.envers.RevisionListener;
import org.jboss.envers.reflection.ReflectionTools;
import org.hibernate.MappingException;
import org.hibernate.property.Setter;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class CustomRevisionInfoGenerator implements RevisionInfoGenerator {
    private RevisionListener listener;
    private Setter revisionTimestampSetter;
    private Class<?> entityClass;

    public CustomRevisionInfoGenerator(VersionsEntitiesConfiguration verEntCfg,
                                       Class<?> entityClass,
                                       Class<? extends RevisionListener> listenerClass) {
        this.entityClass = entityClass;

        revisionTimestampSetter = ReflectionTools.getSetter(entityClass,
                verEntCfg.getRevisionsInfoTimestampName());

        if (!listenerClass.equals(RevisionListener.class)) {
            // This is not the default value.
            try {
                listener = listenerClass.newInstance();
            } catch (InstantiationException e) {
                throw new MappingException(e);
            } catch (IllegalAccessException e) {
                throw new MappingException(e);
            }
        }
    }

    public Object newRevision() {
        Object entity;
        try {
            entity = entityClass.newInstance();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        
        revisionTimestampSetter.set(entity, System.currentTimeMillis(), null);

        if (listener != null) {
            listener.newRevision(entity);
        }

        return entity;
    }
}
