/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.mapper;

import org.jboss.envers.reader.VersionsReaderImplementor;

import java.util.Map;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public interface PropertyMapper {
    /**
     * Maps properties to the given map, basing on differences between properties of new and old objects.
     * @param data Data to map to.
     * @param newObj If the modification store for a property is DIFF, diff-s are created from differences between
     * newObj and oldObj.
     * @param oldObj Data to map from.
     * @return True if there are any differences between the states represented by newObj and oldObj.
     */
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj);

    /**
     * Maps properties from the given map to the given object.
     * @param obj Object to map to.
     * @param data Data to map from.
     * @param primaryKey Primary key of the object to which we map (for relations)
     * @param versionsReader VersionsReader for reading relations
     * @param revision Revision at which the obejct is read, for reading relations
     */
    public void mapToEntityFromMap(Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader,
                            Number revision);
}
