/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.mapper;

import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.ModificationStore;

import java.util.Map;

/**
 * A mapper which maps from a parent mapper and a "main" one, but adds only to the "main". The "main" mapper
 * should be the mapper of the subclass.
 * @author Adam Warski (adam at warski dot org)
 */
public class SubclassPropertyMapper implements ExtendedPropertyMapper {
    private ExtendedPropertyMapper main;
    private ExtendedPropertyMapper parentMapper;

    public SubclassPropertyMapper(ExtendedPropertyMapper main, ExtendedPropertyMapper parentMapper) {
        this.main = main;
        this.parentMapper = parentMapper;
    }

    public boolean map(Map<String, Object> data, String[] propertyNames, Object[] newState, Object[] oldState) {
        boolean parentDiffs = parentMapper.map(data, propertyNames, newState, oldState);
        boolean mainDiffs = main.map(data, propertyNames, newState, oldState);

        return parentDiffs || mainDiffs;
    }

    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        boolean parentDiffs = parentMapper.mapToMapFromEntity(data, newObj, oldObj);
        boolean mainDiffs = main.mapToMapFromEntity(data, newObj, oldObj);

        return parentDiffs || mainDiffs;
    }

    public void mapToEntityFromMap(Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        parentMapper.mapToEntityFromMap(obj, data, primaryKey, versionsReader, revision);
        main.mapToEntityFromMap(obj, data, primaryKey, versionsReader, revision);
    }

    public CompositeMapperBuilder addComposite(String propertyName) {
        return main.addComposite(propertyName);
    }

    public void addComposite(String propertyName, PropertyMapper propertyMapper) {
        main.addComposite(propertyName, propertyMapper);
    }

    public void add(String propertyName, ModificationStore modStore) {
        main.add(propertyName, modStore);
    }
}
