/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.mapper.id;

import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Conjunction;

import java.util.Set;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public abstract class AbstractIdMapper implements IdMapper {
    public Criterion getIdsEqualCriterion(String prefix1, String prefix2) {
        Set<QueryParameterData> paramDatas = mapToQueryParametersFromId(null);

        if (paramDatas.size() == 1) {
            QueryParameterData paramData = paramDatas.iterator().next();
            return Restrictions.eqProperty(paramData.getProperty(prefix1),
                    paramData.getProperty(prefix2));
        } else {
            Conjunction conjunction = Restrictions.conjunction();

            for (QueryParameterData paramData : paramDatas) {
                conjunction.add(Restrictions.eqProperty(paramData.getProperty(prefix1),
                        paramData.getProperty(prefix2)));
            }

            return conjunction;
        }
    }

    public Criterion getIdEqualsCriterion(Object id, String prefix, boolean equals) {
        Set<QueryParameterData> paramDatas = mapToQueryParametersFromId(id);

        if (paramDatas.size() == 1) {
            QueryParameterData paramData = paramDatas.iterator().next();
            if (equals) {
                return Restrictions.eq(paramData.getProperty(prefix), paramData.getValue());
            } else {
                return Restrictions.ne(paramData.getProperty(prefix), paramData.getValue());
            }
        } else {
            Conjunction conjunction = Restrictions.conjunction();

            for (QueryParameterData paramData : paramDatas) {
                if (equals) {
                    conjunction.add(Restrictions.eq(paramData.getProperty(prefix), paramData.getValue()));
                } else {
                    conjunction.add(Restrictions.ne(paramData.getProperty(prefix), paramData.getValue()));
                }
            }

            return conjunction;
        }
    }
}
