/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.mapper.id;

import org.hibernate.criterion.Criterion;

import java.util.Map;
import java.util.Set;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public interface IdMapper {

    public void mapToMapFromId(Map<String, Object> data, Object obj);

    public void mapToMapFromEntity(Map<String, Object> data, Object obj);

    public void mapToEntityFromMap(Object obj, Map data);

    public Object mapToIdFromEntity(Object data);

    public Object mapToIdFromMap(Map data);

    /**
     * Creates a mapper with all mapped properties prefixed. A mapped property is a property which
     * is directly mapped to values (not composite).
     * @param prefix Prefix to add to mapped properties
     * @return A copy of the current property mapper, with mapped properties prefixed.
     */
    public IdMapper prefixMappedProperties(String prefix);

    /**
     * @param obj Id from which to map.
     * @return A set parameter data, needed to build a query basing on the given id.
     */
    public Set<QueryParameterData> mapToQueryParametersFromId(Object obj);

    /**
     * Gets a criteria object, which contains restrictions, which express the property that the id of the entity
     * with alias prefix1, is equal to the id of the entity with alias prefix2 (the entity is the same).
     * @param prefix1 First alias of the entity.
     * @param prefix2 Second alias of the entity.
     * @return A criterion object expressing the property described above.
     */
    public Criterion getIdsEqualCriterion(String prefix1, String prefix2);

    /**
     * Gets a criteria object, which contains restrictions, which express the property that the id of the entity
     * with alias prefix, is equal to the given object.
     * @param id Value of id.
     * @param prefix Alias of the entity (may be null).
     * @param equals Should this criteria express the "=" relation or the "<>" relation.
     * @return A criterion object expressing the property described above.
     */
    public Criterion getIdEqualsCriterion(Object id, String prefix, boolean equals);
}
