/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.mapper.id.relation;

import org.jboss.envers.mapper.PropertyMapper;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.reader.lazy.OneToManyInitializor;
import org.jboss.envers.reader.lazy.proxy.ListProxy;
import org.jboss.envers.reader.lazy.proxy.SetProxy;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reflection.ReflectionTools;
import org.hibernate.property.Setter;
import org.hibernate.property.Getter;

import java.util.*;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class OneToManyIdMapper implements PropertyMapper {
    private String owningReferencePropertyName;
    private String owningEntityName;
    private String propertyName;

    public OneToManyIdMapper(String owningReferencePropertyName, String owningEntityName, String propertyName) {
        this.owningReferencePropertyName = owningReferencePropertyName;
        this.owningEntityName = owningEntityName;
        this.propertyName = propertyName;
    }

    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    public void mapToEntityFromMap(Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        doMap(obj, primaryKey, versionsReader, revision);
    }

    @SuppressWarnings({"unchecked"})
    private void doMap(Object obj, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        if (obj == null) {
            return;
        }

        Class<?> entityClass = ReflectionTools.loadClass(owningEntityName);

        Getter getter = ReflectionTools.getGetter(obj.getClass(), propertyName);
        Class collectionClass = getter.getReturnType();

        // todo: investigate generics
        Object value;
        if (List.class.isAssignableFrom(collectionClass)) {
            value = new ListProxy(new OneToManyInitializor<ArrayList>(versionsReader, entityClass,
                        owningReferencePropertyName, primaryKey, revision, ArrayList.class));
        } else if (Set.class.isAssignableFrom(collectionClass) || Collection.class.isAssignableFrom(collectionClass)) {
            value = new SetProxy(new OneToManyInitializor<HashSet>(versionsReader, entityClass,
                        owningReferencePropertyName, primaryKey, revision, HashSet.class));
        } else {
            throw new VersionsException("Unsupported versioned collection type: " + collectionClass.getName());
        }

        Setter setter = ReflectionTools.getSetter(obj.getClass(), propertyName);
        setter.set(obj, value, null);
    }
}