/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.mapper.id.relation;

import org.jboss.envers.mapper.PropertyMapper;
import org.jboss.envers.mapper.id.IdMapper;
import org.jboss.envers.tools.Tools;
import org.jboss.envers.reflection.ReflectionTools;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.reader.lazy.ToOneDelegateSessionImplementor;
import org.hibernate.property.Setter;

import java.util.Map;
import java.util.HashMap;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class ToOneIdMapper implements PropertyMapper {
    private IdMapper delegate;
    private String propertyName;
    private String referencedEntityName;

    public ToOneIdMapper(IdMapper delegate, String propertyName, String referencedEntityName) {
        this.delegate = delegate;
        this.propertyName = propertyName;
        this.referencedEntityName = referencedEntityName;
    }

    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        HashMap<String, Object> newData = new HashMap<String, Object>();
        data.put(propertyName, newData);

        delegate.mapToMapFromEntity(newData, newObj);

        return !Tools.objectsEqual(newObj, oldObj);
    }

    public void mapToEntityFromMap(Object obj, Map data, Object primaryKey,
                                   VersionsReaderImplementor versionsReader, Number revision) {
        if (obj == null) {
            return;
        }

        Object entityId = delegate.mapToIdFromMap((Map) data.get(propertyName));
        doMap(obj, versionsReader, revision, entityId);
    }

    private void doMap(Object obj, VersionsReaderImplementor versionsReader, Number revision, Object entityId) {
        Object value;
        if (entityId == null) {
            value = null;
        } else {
            Class<?> entityClass = ReflectionTools.loadClass(referencedEntityName);

            value = versionsReader.getSessionImplementor().getFactory().getEntityPersister(referencedEntityName).
                    createProxy(null, new ToOneDelegateSessionImplementor(versionsReader, entityClass, entityId, revision));
        }

        Setter setter = ReflectionTools.getSetter(obj.getClass(), propertyName);
        setter.set(obj, value, null);
    }
}
