/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.metadata;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class RevisionsInfoMetadataGenerator {
    private VersionsEntitiesConfiguration verEntCfg;

    public RevisionsInfoMetadataGenerator(VersionsEntitiesConfiguration verEntCfg) {
        this.verEntCfg = verEntCfg;
    }

    public Document generate() {
        Document document = DocumentHelper.createDocument();

        Element class_mapping = MetadataTools.createEntity(document, verEntCfg.getRevisionsInfoEntityName(),
                null, null, null, null);

        MetadataTools.addNativelyGeneratedId(class_mapping, verEntCfg.getRevisionsInfoIdName(),
                verEntCfg.getRevisionPropType());

        MetadataTools.addProperty(class_mapping, verEntCfg.getRevisionsInfoTimestampName(),
                verEntCfg.getRevisionsInfoTimestampType(), false);

        return document;
    }
}
