/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.metadata.data;

import org.jboss.envers.mapper.id.IdMapper;
import org.dom4j.Element;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class IdMappingData {
    private IdMapper idMapper;
    // Mapping which will be used to generate the entity
    private Element xmlMapping;
    // Mapping which will be used to generate references to the entity in related entities
    private Element xmlRelationMapping;

    public IdMappingData(IdMapper idMapper, Element xmlMapping, Element xmlRelationMapping) {
        this.idMapper = idMapper;
        this.xmlMapping = xmlMapping;
        this.xmlRelationMapping = xmlRelationMapping;
    }

    public IdMapper getIdMapper() {
        return idMapper;
    }

    public Element getXmlMapping() {
        return xmlMapping;
    }

    public Element getXmlRelationMapping() {
        return xmlRelationMapping;
    }
}
