/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.query.impl;

import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.hibernate.criterion.Order;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class RevisionsOfEntityQuery extends AbstractVersionsQuery {
    private boolean selectEntitiesOnly;

    public RevisionsOfEntityQuery(VersionsReaderImplementor versionsReader, Class<?> cls, boolean selectEntitiesOnly) {
        super(versionsReader, cls);

        this.selectEntitiesOnly = selectEntitiesOnly;
    }

    @SuppressWarnings({"unchecked"})
    public List list() throws VersionsException {
        /*
        The query that should be executed in the versions table:
        SELECT e (unless another projection is specified) FROM ent_ver e WHERE
          (all specified conditions, transformed, on the "e" entity)
          ORDER BY e.revision ASC (unless another order is specified)
         */
        String revisionPropertyPath = versionsReader.getEntitiesCfg().getRevisionPropPath();

        // all specified conditions, transformed
        for (VersionsCriterion criterion : criterions) {
            versionsCriteria.add(criterion.toVersionsCriterion(entityName, versionsReader));
        }

        if (!hasProjection && !hasOrder) {
            versionsCriteria.addOrder(Order.asc(revisionPropertyPath));
        }

        List<Map> queryResult = versionsCriteria.list();
        if (hasProjection) {
            return queryResult;
        } else {
            List entities = new ArrayList();
            String originalId = versionsReader.getEntitiesCfg().getOriginalIdPropName();
            String revisionPropertyName = versionsReader.getEntitiesCfg().getRevisionPropName();

            for (Map versionsEntity : queryResult) {
                Number revision = (Number) ((Map) versionsEntity.get(originalId)).get(revisionPropertyName);
                Object entity = entityInstantiator.createInstanceFromVersionsEntity(entityName, versionsEntity, revision);

                if (!selectEntitiesOnly) {
                    entities.add(new Object[] { entity, revision });
                } else {
                    entities.add(entity);
                }
            }

            return entities;
        }
    }
}
