/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.reader.lazy;

import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.reader.lazy.proxy.Initializor;

import java.util.Collection;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class OneToManyInitializor<T extends Collection> implements Initializor<T> {
    private VersionsReaderImplementor versionsReader;
    private Class<?> entityClass;
    private String owningReferencePropertyName;
    private Object primaryKey;
    private Number revision;
    private Class<T> collectionClass;

    public OneToManyInitializor(VersionsReaderImplementor versionsReader, Class<?> entityClass,
                                String owningReferencePropertyName, Object primaryKey, Number revision,
                                Class<T> collectionClass) {
        this.versionsReader = versionsReader;
        this.entityClass = entityClass;
        this.owningReferencePropertyName = owningReferencePropertyName;
        this.primaryKey = primaryKey;
        this.revision = revision;
        this.collectionClass = collectionClass;
    }

    @SuppressWarnings({"unchecked"})
    public T initialize() {
        return (T) versionsReader.findManyReferencing(entityClass, owningReferencePropertyName,
                primaryKey, revision, collectionClass);
    }
}
