/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.synchronization;

import org.jboss.envers.tools.ConcurrentReferenceHashMap;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.hibernate.Session;
import org.hibernate.Transaction;

import java.util.Map;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class VersionsSyncManager {
    private VersionsEntitiesConfiguration verEntCfg;
    private Map<Transaction, VersionsSync> versionsSyncs;

    public VersionsSyncManager(VersionsEntitiesConfiguration verEntCfg) {
        this.verEntCfg = verEntCfg;

        versionsSyncs = new ConcurrentReferenceHashMap<Transaction, VersionsSync>(10,
                ConcurrentReferenceHashMap.ReferenceType.WEAK,
                ConcurrentReferenceHashMap.ReferenceType.STRONG);
    }

    public VersionsEntitiesConfiguration getEntitiesCfg() {
        return verEntCfg;
    }

    public VersionsSync get(Session session) {
        Transaction transaction = session.getTransaction();

        VersionsSync verSync = versionsSyncs.get(transaction);
        if (verSync == null) {
            verSync = new VersionsSync(this, session);
            versionsSyncs.put(transaction, verSync);

            transaction.registerSynchronization(verSync);
        }

        return verSync;
    }

    public void remove(Transaction transaction) {
        versionsSyncs.remove(transaction);
    }
}
