/*
 * Envers. http://www.jboss.org/envers
 *
 * Copyright 2008  Red Hat Middleware, LLC. All rights reserved.
 *
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT A WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License, v.2.1 along with this distribution; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 * Red Hat Author(s): Adam Warski
 */
package org.jboss.envers.synchronization.work;

import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.hibernate.Session;

import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public abstract class AbstractVersionsWorkUnit implements VersionsWorkUnit {
    protected VersionsConfiguration verCfg;
    protected Serializable id;

    private Object performedData;
    private String entityName;

    protected AbstractVersionsWorkUnit(String entityName, VersionsConfiguration verCfg, Serializable id) {
        this.verCfg = verCfg;
        this.id = id;
        this.entityName = entityName;
    }

    protected void fillDataWithId(Map<String, Object> data, Number revision, Byte revisionType) {
        VersionsEntitiesConfiguration entitiesCfg = verCfg.getEntitiesCfg();

        Map<String, Object> originalId = new HashMap<String, Object>();
        originalId.put(entitiesCfg.getRevisionPropName(), revision);

        verCfg.getIdMapper(getEntityName()).mapToMapFromId(originalId, id);
        data.put(entitiesCfg.getRevisionTypePropName(), revisionType);
        data.put(entitiesCfg.getOriginalIdPropName(), originalId);
    }

    public Object getEntityId() {
        return id;
    }

    public boolean isPerformed() {
        return performedData != null;
    }

    public String getEntityName() {
        return entityName;
    }

    protected void setPerformed(Object performedData) {
        this.performedData = performedData;
    }

    public void undo(Session session) {
        if (isPerformed()) {
            session.delete(verCfg.getEntitiesCfg().getVersionsEntityName(getEntityName()), performedData);
            session.flush();
        }
    }
}
