package org.jboss.envers.test.working;

import org.jboss.envers.RevisionNumber;
import org.jboss.envers.RevisionTimestamp;
import org.jboss.envers.RevisionEntity;

import javax.persistence.Id;
import javax.persistence.GeneratedValue;
import javax.persistence.Entity;

/**
 * @author Adam Warski (adam at warski dot org)
 */
@Entity
@RevisionEntity(MyRevisionListener.class)
public class RevEntity {
    @Id
    @GeneratedValue
    @RevisionNumber
    private Integer id;

    @RevisionTimestamp
    private long timestamp;

    private String data;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof RevEntity)) return false;

        RevEntity revEntity = (RevEntity) o;

        if (timestamp != revEntity.timestamp) return false;
        if (data != null ? !data.equals(revEntity.data) : revEntity.data != null) return false;
        if (id != null ? !id.equals(revEntity.id) : revEntity.id != null) return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = (id != null ? id.hashCode() : 0);
        result = 31 * result + (int) (timestamp ^ (timestamp >>> 32));
        result = 31 * result + (data != null ? data.hashCode() : 0);
        return result;
    }
}
