package org.jboss.envers.test.working;

import org.jboss.envers.Versioned;

import javax.persistence.*;

/**
 * @author Adam Warski (adam at warski dot org)
 */
@Entity
@DiscriminatorValue("3001")
@Versioned
public class SubEntity extends AbstrEntity {
    @Basic
    private Long number;

    public SubEntity() {
    }

    public SubEntity(String data, Long number) {
        super(data);
        this.number = number;
    }

    public SubEntity(Integer id, String data, Long number) {
        super(id, data);
        this.number = number;
    }

    public Long getNumber() {
        return number;
    }

    public void setNumber(Long number) {
        this.number = number;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof SubEntity)) return false;
        if (!super.equals(o)) return false;

        SubEntity subEntity = (SubEntity) o;

        if (number != null ? !number.equals(subEntity.number) : subEntity.number != null) return false;

        return true;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (number != null ? number.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SubEntity(id = " + getId() + ", data = " + getData() + ", number = " + number + ")";
    }
}
