package org.jboss.envers.test.working;

import org.jboss.envers.Versioned;
import org.jboss.envers.SecondaryVersionsTable;
import org.jboss.envers.SecondaryVersionsTables;

import javax.persistence.*;

/**
 * @author Adam Warski (adam at warski dot org)
 */
@Entity
//@SecondaryTable(name = "second_table", pkJoinColumns = @PrimaryKeyJoinColumn(name = "join_column_id"))
//@SecondaryVersionsTable(secondaryTableName = "second_table", secondaryVersionsTableName = "sec_tbl_ver")
public class WorkingEntity1 {
    @Id
    @GeneratedValue
    private Integer id1;

    @Versioned
    //@Lob
    private String bb;

    @Versioned
    //@Column(table = "second_table", name = "cc_second")
    private String cc;

    @Versioned
    //@OneToOne
    @ManyToOne
    //@Transient
    private WorkingEntity2 we2;

    public WorkingEntity1() {
    }

    public WorkingEntity1(String bb) {
        this.bb = bb;
    }

    public WorkingEntity1(String bb, String cc) {
        this.bb = bb;
        this.cc = cc;
    }

    public WorkingEntity1(String bb, Integer id1) {
        this.bb = bb;
        this.id1 = id1;
    }

    public Integer getId1() {
        return id1;
    }

    public void setId1(Integer id) {
        this.id1 = id;
    }

    public String getBb() {
        return bb;
    }

    public void setBb(String bb) {
        this.bb = bb;
    }

    public String getCc() {
        return cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public WorkingEntity2 getWe2() {
        return we2;
    }

    public void setWe2(WorkingEntity2 we2) {
        this.we2 = we2;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof WorkingEntity1)) return false;

        WorkingEntity1 that = (WorkingEntity1) o;

        if (bb != null ? !bb.equals(that.bb) : that.bb != null) return false;
        if (id1 != null ? !id1.equals(that.id1) : that.id1 != null) return false;
        if (we2 != null ? !we2.equals(that.we2) : that.we2 != null) return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = (id1 != null ? id1.hashCode() : 0);
        result = 31 * result + (bb != null ? bb.hashCode() : 0);
        result = 31 * result + (we2 != null ? we2.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WE1(id1 = " + id1 + ", bb = " + bb + ", cc = " + cc + ", we2 = " + we2 + ")";
    }
}
