package org.jboss.envers.test.working;

import org.jboss.envers.Versioned;
import org.jboss.envers.test.entities.ids.EmbId;

import javax.persistence.*;
import java.util.Set;

/**
 * @author Adam Warski (adam at warski dot org)
 */
@Entity
public class WorkingEntity2 {
    @Id
    @GeneratedValue
    //@Column(name = "Z")
    private Integer id2;

    @Versioned
    @Column
    private String str2;

    @Versioned
    @OneToMany(mappedBy = "we2")
    //@ManyToMany
    //@Transient
    private Set<WorkingEntity1> we1s;

    //@Versioned
    //@OneToOne(mappedBy = "we2")
    @Transient
    private WorkingEntity1 we1;

    //@Versioned
    //@ManyToOne
    @Transient
    private WorkingEntity3 we3;

    public WorkingEntity2() {
    }

    public WorkingEntity2(Integer id2, String str2) {
        this.id2 = id2;
        this.str2 = str2;
    }

    public WorkingEntity2(String str2) {
        this.str2 = str2;
    }

    public Integer getId2() {
        return id2;
    }

    public void setId2(Integer id2) {
        this.id2 = id2;
    }

    public String getStr2() {
        return str2;
    }

    public void setStr2(String str2) {
        this.str2 = str2;
    }

    public WorkingEntity1 getWe1() {
        return we1;
    }

    public void setWe1(WorkingEntity1 we1) {
        this.we1 = we1;
    }

    public WorkingEntity3 getWe3() {
        return we3;
    }

    public void setWe3(WorkingEntity3 we3) {
        this.we3 = we3;
    }

    public Set<WorkingEntity1> getWe1s() {
        return we1s;
    }

    public void setWe1s(Set<WorkingEntity1> we1s) {
        this.we1s = we1s;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof WorkingEntity2)) return false;

        WorkingEntity2 that = (WorkingEntity2) o;

        if (id2 != null ? !id2.equals(that.id2) : that.id2 != null) return false;
        if (str2 != null ? !str2.equals(that.str2) : that.str2 != null) return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = (id2 != null ? id2.hashCode() : 0);
        result = 31 * result + (str2 != null ? str2.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WE2(id2 = " + id2 +", str2 = " + str2 + ")";
    }
}