package org.jboss.envers.test.working;

import org.jboss.envers.Versioned;

import javax.persistence.*;
import java.util.Set;

/**
 * @author Adam Warski (adam at warski dot org)
 */
@Entity
public class WorkingEntity3 {
    @Id
    @GeneratedValue
    private Integer id3;

    @Versioned
    @Column
    private String str3;

    @Versioned
    @OneToMany(mappedBy = "we3")
    private Set<WorkingEntity2> we2s;

    public WorkingEntity3() {
    }

    public WorkingEntity3(Integer id3, String str3) {
        this.id3 = id3;
        this.str3 = str3;
    }

    public WorkingEntity3(String str3) {
        this.str3 = str3;
    }

    public Integer getId3() {
        return id3;
    }

    public void setId3(Integer id3) {
        this.id3 = id3;
    }

    public String getStr3() {
        return str3;
    }

    public void setStr3(String str3) {
        this.str3 = str3;
    }

    public Set<WorkingEntity2> getWe2s() {
        return we2s;
    }

    public void setWe2(Set<WorkingEntity2> we2s) {
        this.we2s = we2s;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof WorkingEntity3)) return false;

        WorkingEntity3 that = (WorkingEntity3) o;

        if (id3 != null ? !id3.equals(that.id3) : that.id3 != null) return false;
        if (str3 != null ? !str3.equals(that.str3) : that.str3 != null) return false;

        return true;
    }

    public int hashCode() {
        int result;
        result = (id3 != null ? id3.hashCode() : 0);
        result = 31 * result + (str3 != null ? str3.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WE3(id3 = " + id3 +", str3 = " + str3 + ")";
    }
}