package org.jboss.envers.test.working;

import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.Session;
import org.hibernate.Criteria;
import org.hibernate.tool.ant.EnversHibernateToolTask;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.jboss.envers.VersionsReader;
import org.jboss.envers.VersionsReaderFactory;
import org.jboss.envers.test.entities.ids.EmbId;
import org.jboss.envers.test.working.bug.ContactMech;
import org.jboss.envers.test.working.bug.PostalAddress;
import org.jboss.envers.test.integration.inheritance.single.relation.ReferencedEntity;
import org.jboss.envers.test.integration.inheritance.single.relation.ParentIngEntity;
import org.jboss.envers.test.integration.inheritance.single.relation.ChildIngEntity;
import org.jboss.envers.query.criteria.VersionsCriterion;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import java.io.IOException;
import java.util.*;

/**
 * @author Adam Warski (adam at warski dot org)
 */
public class WorkingMain {
    private static Session getSession(EntityManager em) {
        Object delegate = em.getDelegate();
        if (delegate instanceof Session) {
            return (Session) delegate;
        } else if (delegate instanceof EntityManager) {
            Object delegate2 = ((EntityManager) delegate).getDelegate();

            if (delegate2 instanceof Session) {
                return (Session) delegate2;
            }
        }

        throw new RuntimeException("Invalid entity manager");
    }

    @SuppressWarnings({"unchecked"})
    public static void main(String[] args) throws IOException {
        Ejb3Configuration cfg = new Ejb3Configuration();
        cfg.configure("hibernate.test.cfg.xml");
        cfg.addAnnotatedClass(WorkingEntity1.class);
        cfg.addAnnotatedClass(WorkingEntity2.class);
        //cfg.addAnnotatedClass(RevEntity.class);
        //cfg.addAnnotatedClass(PostalAddress.class);
        //cfg.addAnnotatedClass(ContactMech.class);

        EntityManagerFactory emf = cfg.buildEntityManagerFactory();
        EntityManager entityManager = emf.createEntityManager();

        // Rev 1
        entityManager.getTransaction().begin();



        entityManager.getTransaction().commit();      
    }
}

