package org.jboss.envers.test.working.bug;

import org.jboss.envers.Versioned;

import javax.persistence.*;

@Entity
@Inheritance(strategy = InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name = "contact_mech_type_id", discriminatorType = DiscriminatorType.INTEGER)
@Table(name = "contact_mech")
@Versioned
public abstract class ContactMech {
    private Integer id;

    @Id
    @GeneratedValue
    @Column(name = "contact_mech_id", nullable = false, insertable = true, updatable = true, length = 10)
    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    private String infoString;

    @Basic
    @Column(name = "info_string")
    public String getInfoString() {
        return infoString;
    }

    public void setInfoString(String infoString) {
        this.infoString = infoString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        ContactMech that = (ContactMech) o;

        if (id != null ? !id.equals(that.id) : that.id != null)
            return false;
        if (infoString != null ? !infoString.equals(that.infoString) : that.infoString != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result;
        result = (id != null ? id.hashCode() : 0);
        result = 31 * result + (infoString != null ? infoString.hashCode() : 0);
        return result;
    }
}

