package org.jboss.envers.test.working.bug;

import org.jboss.envers.Versioned;

import javax.persistence.*;

@Entity
@DiscriminatorValue("3001")
@SecondaryTable(name = "postal_address", pkJoinColumns = @PrimaryKeyJoinColumn(name = "contact_mech_id"))
@Versioned
public class PostalAddress extends ContactMech {
    private String toName;

    @Basic
    @Column(table = "postal_address", name = "to_name", nullable = true, insertable = true, updatable = true, length = 100)
    public String getToName() {
        return toName;
    }

    public void setToName(String toName) {
        this.toName = toName;
    }

    private String attnName;

    @Basic
    @Column(table = "postal_address", name = "attn_name", nullable = true, insertable = true, updatable = true, length = 100)
    public String getAttnName() {
        return attnName;
    }

    public void setAttnName(String attnName) {
        this.attnName = attnName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        PostalAddress that = (PostalAddress) o;

        if (attnName != null ? !attnName.equals(that.attnName) : that.attnName != null) return false;
// if (contactMechId != null ? !contactMechId.equals(that.contactMechId) : that.contactMechId != null)
// return false;
        if (toName != null ? !toName.equals(that.toName) : that.toName != null) return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result;
// result = (contactMechId != null ? contactMechId.hashCode() : 0);
        result = /*31 * result + */(toName != null ? toName.hashCode() : 0);
        result = 31 * result + (attnName != null ? attnName.hashCode() : 0);
        return result;
    }
}