/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import java.util.HashMap;
import java.util.Map;
import org.jboss.envers.configuration.RelationDescription;
import org.jboss.envers.mapper.ExtendedPropertyMapper;
import org.jboss.envers.mapper.id.IdMapper;
import org.jboss.envers.metadata.data.IdMappingData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityConfiguration {
    private String entityName;
    private String versionsEntityName;
    private IdMappingData idMappingData;
    private ExtendedPropertyMapper propertyMapper;
    private Map<String, RelationDescription> relations;
    private String parentEntityName;

    public EntityConfiguration(String entityName, String versionsEntityName, IdMappingData idMappingData, ExtendedPropertyMapper propertyMapper, String parentEntityName) {
        this.entityName = entityName;
        this.versionsEntityName = versionsEntityName;
        this.idMappingData = idMappingData;
        this.propertyMapper = propertyMapper;
        this.parentEntityName = parentEntityName;
        this.relations = new HashMap<String, RelationDescription>();
    }

    public void addToOneRelation(String fromPropertyName, String toEntityName, IdMapper idMapper) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationDescription.RelationType.TO_ONE, toEntityName, null, idMapper));
    }

    public void addOneToOneRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName, IdMapper idMapper) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationDescription.RelationType.ONE_TO_ONE, toEntityName, mappedByPropertyName, idMapper));
    }

    public void addOneToManyRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName, IdMapper idMapper) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationDescription.RelationType.ONE_TO_MANY, toEntityName, mappedByPropertyName, idMapper));
    }

    public boolean isRelation(String propertyName) {
        return this.relations.get(propertyName) != null;
    }

    public Iterable<RelationDescription> getRelationsIterator() {
        return this.relations.values();
    }

    public RelationDescription getRelationDescription(String propertyName) {
        return this.relations.get(propertyName);
    }

    public IdMappingData getIdMappingData() {
        return this.idMappingData;
    }

    public ExtendedPropertyMapper getPropertyMapper() {
        return this.propertyMapper;
    }

    public String getParentEntityName() {
        return this.parentEntityName;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getVersionsEntityName() {
        return this.versionsEntityName;
    }
}

