/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entity;

import java.util.List;
import java.util.Map;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.mapper.id.IdMapper;
import org.jboss.envers.metadata.RevisionType;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityInstantiator {
    private VersionsReaderImplementor versionsReader;
    private VersionsConfiguration verCfg;

    public EntityInstantiator(VersionsReaderImplementor versionsReader) {
        this.versionsReader = versionsReader;
        this.verCfg = versionsReader.getVerCfg();
    }

    public Object createInstanceFromVersionsEntity(String entityName, Map versionsEntity, Number revision) {
        Object ret;
        if (versionsEntity == null) {
            return null;
        }
        if (RevisionType.DEL.equals(versionsEntity.get(this.verCfg.getEntitiesCfg().getRevisionTypePropName()))) {
            return null;
        }
        String type = this.verCfg.getEntityNameForVersionsEntityName((String)versionsEntity.get("$type$"));
        if (type != null) {
            entityName = type;
        }
        try {
            Class<?> cls = ReflectionTools.loadClass(entityName);
            ret = cls.newInstance();
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
        IdMapper idMapper = this.verCfg.getIdMapper(entityName);
        Map originalId = (Map)versionsEntity.get(this.verCfg.getEntitiesCfg().getOriginalIdPropName());
        Object primaryKey = idMapper.mapToIdFromMap(originalId);
        this.verCfg.getPropertyMapper(entityName).mapToEntityFromMap(ret, versionsEntity, primaryKey, this.versionsReader, revision);
        idMapper.mapToEntityFromMap(ret, originalId);
        return ret;
    }

    public void addInstancesFromVersionsEntities(String entityName, List list, List<Map> versionsEntities, Number revision) {
        for (Map versionsEntity : versionsEntities) {
            list.add(this.createInstanceFromVersionsEntity(entityName, versionsEntity, revision));
        }
    }
}

