/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.log;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.log.YLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YLogManager {
    private Method getLogMethod;
    private Class argClass;
    private static YLogManager instance;

    private YLogManager() {
        this.initMethod();
    }

    private void initMethod() {
        ClassLoader cl = YLogManager.class.getClassLoader();
        try {
            Class<?> logFactoryClass = cl.loadClass("org.apache.commons.logging.LogFactory");
            try {
                this.getLogMethod = logFactoryClass.getMethod("getLog", Class.class);
                this.argClass = Object.class;
            }
            catch (NoSuchMethodException e) {
                throw new VersionsException("No 'getLog' method in org.apache.commons.logging.LogFactory.");
            }
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> loggerFactoryClass = cl.loadClass("org.slf4j.LoggerFactory");
                try {
                    this.getLogMethod = loggerFactoryClass.getMethod("getLogger", Class.class);
                    this.argClass = String.class;
                }
                catch (NoSuchMethodException e1) {
                    throw new VersionsException("No 'getLogger' method in org.slf4j.LoggerFactory.");
                }
            }
            catch (ClassNotFoundException e1) {
                throw new VersionsException("No org.apache.commons.logging.LogFactory or org.slf4j.LoggerFactory found.");
            }
        }
    }

    public YLog getLog(Class<?> cls) {
        try {
            return new YLog(this.getLogMethod.invoke(null, cls), this.argClass);
        }
        catch (IllegalAccessException e) {
            throw new VersionsException(e);
        }
        catch (InvocationTargetException e) {
            throw new VersionsException(e);
        }
    }

    public static synchronized YLogManager getLogManager() {
        if (instance == null) {
            instance = new YLogManager();
        }
        return instance;
    }
}

