/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.mapper;

import java.util.Map;
import org.hibernate.property.Setter;
import org.jboss.envers.ModificationStore;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.mapper.PropertyMapper;
import org.jboss.envers.mapper.SimpleMapperBuilder;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.reflection.ReflectionTools;
import org.jboss.envers.tools.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePropertyMapper
implements PropertyMapper,
SimpleMapperBuilder {
    private String propertyName;

    public SinglePropertyMapper(String propertyName, ModificationStore modStore) {
        this.propertyName = propertyName;
    }

    public SinglePropertyMapper() {
    }

    @Override
    public void add(String propertyName, ModificationStore modStore) {
        if (this.propertyName != null) {
            throw new VersionsException("Only one property can be added!");
        }
        this.propertyName = propertyName;
    }

    @Override
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        data.put(this.propertyName, newObj);
        return !Tools.objectsEqual(newObj, oldObj);
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        if (data == null || obj == null) {
            return;
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyName);
        setter.set(obj, data.get(this.propertyName), null);
    }
}

