/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.mapper.id.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.mapper.PropertyMapper;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.reader.lazy.OneToManyInitializor;
import org.jboss.envers.reader.lazy.proxy.CollectionProxy;
import org.jboss.envers.reader.lazy.proxy.ListProxy;
import org.jboss.envers.reader.lazy.proxy.SetProxy;
import org.jboss.envers.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyIdMapper
implements PropertyMapper {
    private String owningReferencePropertyName;
    private String owningEntityName;
    private String propertyName;

    public OneToManyIdMapper(String owningReferencePropertyName, String owningEntityName, String propertyName) {
        this.owningReferencePropertyName = owningReferencePropertyName;
        this.owningEntityName = owningEntityName;
        this.propertyName = propertyName;
    }

    @Override
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        return false;
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        this.doMap(obj, primaryKey, versionsReader, revision);
    }

    private void doMap(Object obj, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        CollectionProxy value;
        if (obj == null) {
            return;
        }
        Class<?> entityClass = ReflectionTools.loadClass(this.owningEntityName);
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.propertyName);
        Class collectionClass = getter.getReturnType();
        if (List.class.isAssignableFrom(collectionClass)) {
            value = new ListProxy(new OneToManyInitializor(versionsReader, entityClass, this.owningReferencePropertyName, primaryKey, revision, ArrayList.class));
        } else if (Set.class.isAssignableFrom(collectionClass) || Collection.class.isAssignableFrom(collectionClass)) {
            value = new SetProxy(new OneToManyInitializor(versionsReader, entityClass, this.owningReferencePropertyName, primaryKey, revision, HashSet.class));
        } else {
            throw new VersionsException("Unsupported versioned collection type: " + collectionClass.getName());
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyName);
        setter.set(obj, value, null);
    }
}

