/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.criteria;

import org.hibernate.criterion.Criterion;
import org.jboss.envers.configuration.RelationDescription;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.criteria.CriteriaTools;
import org.jboss.envers.query.criteria.PublicSimpleExpression;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.jboss.envers.reader.VersionsReaderImplementor;

public class SimpleVersionsExpression
implements VersionsCriterion {
    private String propertyName;
    private Object value;
    private String op;
    private boolean ignoreCase;

    public SimpleVersionsExpression(String propertyName, Object value, String op) {
        this.propertyName = propertyName;
        this.value = value;
        this.op = op;
    }

    public SimpleVersionsExpression(String propertyName, Object value, String op, boolean ignoreCase) {
        this.propertyName = propertyName;
        this.value = value;
        this.op = op;
        this.ignoreCase = ignoreCase;
    }

    public Criterion toVersionsCriterion(String entityName, VersionsReaderImplementor versionsReader) throws VersionsException {
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(versionsReader, entityName, this.propertyName);
        if (relatedEntity == null) {
            return new PublicSimpleExpression(this.propertyName, this.value, this.op, this.ignoreCase);
        }
        if (!"=".equals(this.op) && !"<>".equals(this.op)) {
            throw new VersionsException("This type of operation: " + this.op + " (" + entityName + "." + this.propertyName + ") isn't supported and can't be used in queries.");
        }
        Object id = relatedEntity.idMapper.mapToIdFromEntity(this.value);
        return relatedEntity.idMapper.getIdEqualsCriterion(id, this.propertyName, "=".equals(this.op));
    }
}

