/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.jboss.envers.entity.EntityInstantiator;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.VersionsQuery;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.jboss.envers.query.order.VersionsOrder;
import org.jboss.envers.query.projection.VersionsProjection;
import org.jboss.envers.reader.VersionsReaderImplementor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVersionsQuery
implements VersionsQuery {
    protected VersionsReaderImplementor versionsReader;
    protected EntityInstantiator entityInstantiator;
    protected List<VersionsCriterion> criterions;
    protected String entityName;
    protected String versionsEntityName;
    protected Criteria versionsCriteria;
    protected boolean hasProjection;
    protected boolean hasOrder;

    protected AbstractVersionsQuery(VersionsReaderImplementor versionsReader, Class<?> cls) {
        this.versionsReader = versionsReader;
        this.criterions = new ArrayList<VersionsCriterion>();
        this.entityInstantiator = new EntityInstantiator(versionsReader);
        this.entityName = cls.getName();
        this.versionsEntityName = versionsReader.getEntitiesCfg().getVersionsEntityName(this.entityName);
        this.versionsCriteria = versionsReader.getSession().createCriteria(this.versionsEntityName, "e");
    }

    public abstract List list() throws VersionsException;

    @Override
    public List getResultList() throws VersionsException {
        return this.list();
    }

    @Override
    public Object getSingleResult() throws VersionsException, NonUniqueResultException, NoResultException {
        List result = this.list();
        if (result == null || result.size() == 0) {
            throw new NoResultException();
        }
        if (result.size() > 1) {
            throw new NonUniqueResultException();
        }
        return result.get(0);
    }

    @Override
    public VersionsQuery add(VersionsCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public VersionsQuery setProjection(Projection projection) {
        this.hasProjection = true;
        this.versionsCriteria.setProjection(projection);
        return this;
    }

    @Override
    public VersionsQuery setProjection(VersionsProjection projection) {
        this.hasProjection = true;
        this.versionsCriteria.setProjection(projection.getProjection(this.entityName, this.versionsReader));
        return this;
    }

    @Override
    public VersionsQuery addOrder(Order order) {
        this.hasOrder = true;
        this.versionsCriteria.addOrder(order);
        return this;
    }

    @Override
    public VersionsQuery addOrder(VersionsOrder order) {
        this.hasOrder = true;
        this.versionsCriteria.addOrder(order.getOrder(this.entityName, this.versionsReader));
        return this;
    }

    @Override
    public VersionsQuery setMaxResults(int maxResults) {
        this.versionsCriteria.setMaxResults(maxResults);
        return this;
    }

    @Override
    public VersionsQuery setFirstResult(int firstResult) {
        this.versionsCriteria.setFirstResult(firstResult);
        return this;
    }

    @Override
    public VersionsQuery setCacheable(boolean cacheable) {
        this.versionsCriteria.setCacheable(cacheable);
        return this;
    }

    @Override
    public VersionsQuery setCacheRegion(String cacheRegion) {
        this.versionsCriteria.setCacheRegion(cacheRegion);
        return this;
    }

    @Override
    public VersionsQuery setComment(String comment) {
        this.versionsCriteria.setComment(comment);
        return this;
    }

    @Override
    public VersionsQuery setFlushMode(FlushMode flushMode) {
        this.versionsCriteria.setFlushMode(flushMode);
        return this;
    }

    @Override
    public VersionsQuery setCacheMode(CacheMode cacheMode) {
        this.versionsCriteria.setCacheMode(cacheMode);
        return this;
    }

    @Override
    public VersionsQuery setTimeout(int timeout) {
        this.versionsCriteria.setTimeout(timeout);
        return this;
    }

    @Override
    public VersionsQuery setLockMode(LockMode lockMode) {
        this.versionsCriteria.setLockMode(lockMode);
        return this;
    }
}

