/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.reflection;

import java.lang.reflect.Method;
import org.jboss.envers.exception.VersionsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YMethodsAndClasses {
    private Method reflectionManager_classForNameMethod;
    private Method reflectionManager_equalsMethod;
    private Method xClass_getNameMethod;
    private Method xClass_getSuperclassMethod;
    private Method xClass_getDeclaredPropertiesMethod;
    private Method xClass_getAnnotationMethod;
    private Method xProperty_getNameMethod;
    private Method xProperty_getAnnotationMethod;
    private Method xProperty_getTypeMethod;
    private Class reflectionManagerClass;
    private Class xClassClass;
    private Class xPropertyClass;

    public YMethodsAndClasses(Class<?> delegateClass) throws Exception {
        this.initClasses(delegateClass);
        this.initMethods();
    }

    private void initMethods() throws Exception {
        this.reflectionManager_classForNameMethod = this.reflectionManagerClass.getMethod("classForName", String.class, Class.class);
        this.reflectionManager_equalsMethod = this.reflectionManagerClass.getMethod("equals", this.xClassClass, Class.class);
        this.xClass_getNameMethod = this.xClassClass.getMethod("getName", new Class[0]);
        this.xClass_getSuperclassMethod = this.xClassClass.getMethod("getSuperclass", new Class[0]);
        this.xClass_getDeclaredPropertiesMethod = this.xClassClass.getMethod("getDeclaredProperties", String.class);
        this.xClass_getAnnotationMethod = this.xClassClass.getMethod("getAnnotation", Class.class);
        this.xProperty_getNameMethod = this.xPropertyClass.getMethod("getName", new Class[0]);
        this.xProperty_getTypeMethod = this.xPropertyClass.getMethod("getType", new Class[0]);
        this.xProperty_getAnnotationMethod = this.xPropertyClass.getMethod("getAnnotation", Class.class);
    }

    private void initClasses(Class<?> delegateClass) {
        ClassLoader cl = YMethodsAndClasses.class.getClassLoader();
        this.reflectionManagerClass = delegateClass;
        try {
            this.xClassClass = cl.loadClass("org.hibernate.annotations.common.reflection.XClass");
        }
        catch (ClassNotFoundException e) {
            try {
                this.xClassClass = cl.loadClass("org.hibernate.reflection.XClass");
            }
            catch (ClassNotFoundException e1) {
                throw new VersionsException("No XClass found.");
            }
        }
        try {
            this.xPropertyClass = cl.loadClass("org.hibernate.annotations.common.reflection.XProperty");
        }
        catch (ClassNotFoundException e) {
            try {
                this.xPropertyClass = cl.loadClass("org.hibernate.reflection.XProperty");
            }
            catch (ClassNotFoundException e1) {
                throw new VersionsException("No XProperty found.");
            }
        }
    }

    public Method getXClass_getNameMethod() {
        return this.xClass_getNameMethod;
    }

    public Method getXClass_getSuperclassMethod() {
        return this.xClass_getSuperclassMethod;
    }

    public Method getXClass_getDeclaredPropertiesMethod() {
        return this.xClass_getDeclaredPropertiesMethod;
    }

    public Method getXClass_getAnnotationMethod() {
        return this.xClass_getAnnotationMethod;
    }

    public Method getXProperty_getNameMethod() {
        return this.xProperty_getNameMethod;
    }

    public Method getXProperty_getAnnotationMethod() {
        return this.xProperty_getAnnotationMethod;
    }

    public Method getXProperty_getTypeMethod() {
        return this.xProperty_getTypeMethod;
    }

    public Method getReflectionManager_classForNameMethod() {
        return this.reflectionManager_classForNameMethod;
    }

    public Method getReflectionManager_equalsMethod() {
        return this.reflectionManager_equalsMethod;
    }
}

