/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers;

import java.text.DateFormat;
import java.util.Date;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.jboss.envers.RevisionNumber;
import org.jboss.envers.RevisionTimestamp;

@MappedSuperclass
public class DefaultRevisionEntity {
    @Id
    @GeneratedValue
    @RevisionNumber
    private int id;
    @RevisionTimestamp
    private long timestamp;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Transient
    public Date getRevisionDate() {
        return new Date(this.timestamp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultRevisionEntity)) {
            return false;
        }
        DefaultRevisionEntity that = (DefaultRevisionEntity)o;
        if (this.id != that.id) {
            return false;
        }
        return this.timestamp == that.timestamp;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        return "DefaultRevisionEntity(id = " + this.id + ", revisionDate = " + DateFormat.getDateTimeInstance().format(this.getRevisionDate()) + ")";
    }
}

