/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;
import org.jboss.envers.ModificationStore;
import org.jboss.envers.VersionsJoinTable;
import org.jboss.envers.configuration.GlobalConfiguration;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.configuration.metadata.BasicMetadataGenerator;
import org.jboss.envers.configuration.metadata.CollectionMetadataGenerator;
import org.jboss.envers.configuration.metadata.EntityXmlMappingData;
import org.jboss.envers.configuration.metadata.IdMetadataGenerator;
import org.jboss.envers.configuration.metadata.InheritanceType;
import org.jboss.envers.configuration.metadata.MetadataTools;
import org.jboss.envers.configuration.metadata.PersistentClassVersioningData;
import org.jboss.envers.configuration.metadata.PropertyStoreInfo;
import org.jboss.envers.configuration.metadata.ToOneRelationMetadataGenerator;
import org.jboss.envers.entities.EntityConfiguration;
import org.jboss.envers.entities.IdMappingData;
import org.jboss.envers.entities.mapper.CompositeMapperBuilder;
import org.jboss.envers.entities.mapper.ExtendedPropertyMapper;
import org.jboss.envers.entities.mapper.MultiPropertyMapper;
import org.jboss.envers.entities.mapper.SubclassPropertyMapper;
import org.jboss.envers.tools.HibernateVersion;
import org.jboss.envers.tools.StringTools;
import org.jboss.envers.tools.log.YLog;
import org.jboss.envers.tools.log.YLogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VersionsMetadataGenerator {
    private final Configuration cfg;
    private final GlobalConfiguration globalCfg;
    private final VersionsEntitiesConfiguration verEntCfg;
    private final Element revisionInfoRelationMapping;
    private final BasicMetadataGenerator basicMetadataGenerator;
    private final IdMetadataGenerator idMetadataGenerator;
    private final ToOneRelationMetadataGenerator toOneRelationMetadataGenerator;
    private final Map<String, EntityConfiguration> entitiesConfigurations;
    private final Map<String, Map<Join, Element>> entitiesJoins;
    private YLog log = YLogManager.getLogManager().getLog(VersionsMetadataGenerator.class);

    public VersionsMetadataGenerator(Configuration cfg, GlobalConfiguration globalCfg, VersionsEntitiesConfiguration verEntCfg, Element revisionInfoRelationMapping) {
        this.cfg = cfg;
        this.globalCfg = globalCfg;
        this.verEntCfg = verEntCfg;
        this.revisionInfoRelationMapping = revisionInfoRelationMapping;
        this.basicMetadataGenerator = new BasicMetadataGenerator();
        this.idMetadataGenerator = new IdMetadataGenerator(this);
        this.toOneRelationMetadataGenerator = new ToOneRelationMetadataGenerator(this);
        this.entitiesConfigurations = new HashMap<String, EntityConfiguration>();
        this.entitiesJoins = new HashMap<String, Map<Join, Element>>();
    }

    void addRevisionInfoRelation(Element any_mapping) {
        Element rev_mapping = (Element)this.revisionInfoRelationMapping.clone();
        rev_mapping.addAttribute("name", this.verEntCfg.getRevisionPropName());
        MetadataTools.addColumn(rev_mapping, this.verEntCfg.getRevisionPropName(), null);
        any_mapping.add(rev_mapping);
    }

    void addRevisionType(Element any_mapping) {
        Element revTypeProperty = MetadataTools.addProperty(any_mapping, this.verEntCfg.getRevisionTypePropName(), this.verEntCfg.getRevisionTypePropType(), false);
        revTypeProperty.addAttribute("type", "org.jboss.envers.entities.RevisionTypeType");
    }

    private ModificationStore getStoreForProperty(Property property, PropertyStoreInfo propertyStoreInfo, List<String> unversionedProperties) {
        if (unversionedProperties.contains(property.getName())) {
            return null;
        }
        ModificationStore store = propertyStoreInfo.propertyStores.get(property.getName());
        if (store == null) {
            return propertyStoreInfo.defaultStore;
        }
        return store;
    }

    void addValue(Element parent, String name, Value value, CompositeMapperBuilder currentMapper, ModificationStore store, String entityName, EntityXmlMappingData xmlMappingData, VersionsJoinTable joinTable, String mapKey, boolean firstPass) {
        Type type = value.getType();
        if (firstPass && this.basicMetadataGenerator.addBasic(parent, name, value, currentMapper, store, entityName, false)) {
            return;
        }
        if (type instanceof ManyToOneType) {
            if (!firstPass) {
                this.toOneRelationMetadataGenerator.addToOne(parent, name, value, currentMapper, entityName);
            }
        } else if (type instanceof OneToOneType) {
            if (!firstPass) {
                this.toOneRelationMetadataGenerator.addOneToOneNotOwning(name, value, currentMapper, entityName);
            }
        } else if (type instanceof CollectionType) {
            if (!firstPass) {
                CollectionMetadataGenerator collectionMetadataGenerator = new CollectionMetadataGenerator(this, name, (Collection)value, currentMapper, entityName, xmlMappingData, joinTable, mapKey);
                collectionMetadataGenerator.addCollection();
            }
        } else if (firstPass) {
            this.throwUnsupportedTypeException(type, entityName, name);
        }
    }

    private void addProperties(Element parent, Iterator<Property> properties, CompositeMapperBuilder currentMapper, PersistentClassVersioningData versioningData, String entityName, EntityXmlMappingData xmlMappingData, boolean firstPass) {
        while (properties.hasNext()) {
            ModificationStore store;
            Property property = properties.next();
            if ("_identifierMapper".equals(property.getName()) || (store = this.getStoreForProperty(property, versioningData.propertyStoreInfo, versioningData.unversionedProperties)) == null) continue;
            this.addValue(parent, property.getName(), property.getValue(), currentMapper, store, entityName, xmlMappingData, versioningData.versionsJoinTables.get(property.getName()), versioningData.mapKeys.get(property.getName()), firstPass);
        }
    }

    private void createJoins(PersistentClass pc, Element parent, PersistentClassVersioningData versioningData) {
        Iterator joins = pc.getJoinIterator();
        HashMap<Join, Element> joinElements = new HashMap<Join, Element>();
        this.entitiesJoins.put(pc.getEntityName(), joinElements);
        while (joins.hasNext()) {
            String catalog;
            String schema;
            Join join = (Join)joins.next();
            String originalTableName = join.getTable().getName();
            String versionedTableName = versioningData.secondaryTableDictionary.get(originalTableName);
            if (versionedTableName == null) {
                versionedTableName = this.verEntCfg.getVersionsEntityName(originalTableName);
            }
            if (StringTools.isEmpty(schema = versioningData.versionsTable.schema())) {
                schema = join.getTable().getSchema();
            }
            if (StringTools.isEmpty(catalog = versioningData.versionsTable.catalog())) {
                catalog = join.getTable().getCatalog();
            }
            Element joinElement = MetadataTools.createJoin(parent, versionedTableName, schema, catalog);
            joinElements.put(join, joinElement);
            Element joinKey = joinElement.addElement("key");
            MetadataTools.addColumns(joinKey, join.getKey().getColumnIterator());
            MetadataTools.addColumn(joinKey, this.verEntCfg.getRevisionPropName(), null);
        }
    }

    private void addJoins(PersistentClass pc, CompositeMapperBuilder currentMapper, PersistentClassVersioningData versioningData, String entityName, EntityXmlMappingData xmlMappingData, boolean firstPass) {
        Iterator joins = pc.getJoinIterator();
        while (joins.hasNext()) {
            Join join = (Join)joins.next();
            Element joinElement = this.entitiesJoins.get(entityName).get(join);
            this.addProperties(joinElement, join.getPropertyIterator(), currentMapper, versioningData, entityName, xmlMappingData, firstPass);
        }
    }

    private void addPersisterHack(Element class_mapping) {
        String persisterClassName = HibernateVersion.get().startsWith("3.3") ? "org.jboss.envers.entity.VersionsInheritanceEntityPersisterFor33" : "org.jboss.envers.entity.VersionsInheritanceEntityPersisterFor32";
        class_mapping.addAttribute("persister", persisterClassName);
    }

    public void generateFirstPass(PersistentClass pc, PersistentClassVersioningData versioningData, EntityXmlMappingData xmlMappingData) {
        ExtendedPropertyMapper propertyMapper;
        Element class_mapping;
        String catalog;
        String schema = versioningData.versionsTable.schema();
        if (StringTools.isEmpty(schema)) {
            schema = pc.getTable().getSchema();
        }
        if (StringTools.isEmpty(catalog = versioningData.versionsTable.catalog())) {
            catalog = pc.getTable().getCatalog();
        }
        String entityName = pc.getEntityName();
        String versionsEntityName = this.verEntCfg.getVersionsEntityName(entityName);
        String versionsTableName = this.verEntCfg.getVersionsTableName(entityName, pc.getTable().getName());
        IdMappingData idMapper = this.idMetadataGenerator.addId(pc);
        InheritanceType inheritanceType = InheritanceType.get(pc);
        String parentEntityName = null;
        switch (inheritanceType) {
            case NONE: {
                class_mapping = MetadataTools.createEntity(xmlMappingData.getMainXmlMapping(), versionsEntityName, versionsTableName, schema, catalog, pc.getDiscriminatorValue());
                propertyMapper = new MultiPropertyMapper();
                if (pc.getDiscriminator() != null) {
                    Element discriminator_element = class_mapping.addElement("discriminator");
                    MetadataTools.addColumns(discriminator_element, pc.getDiscriminator().getColumnIterator());
                    discriminator_element.addAttribute("type", pc.getDiscriminator().getType().getName());
                    this.addPersisterHack(class_mapping);
                }
                class_mapping.add((Element)idMapper.getXmlMapping().clone());
                this.addRevisionType(class_mapping);
                break;
            }
            case SINGLE: {
                String extendsEntityName = this.verEntCfg.getVersionsEntityName(pc.getSuperclass().getEntityName());
                class_mapping = MetadataTools.createSubclassEntity(xmlMappingData.getMainXmlMapping(), versionsEntityName, versionsTableName, schema, catalog, extendsEntityName, pc.getDiscriminatorValue());
                this.addPersisterHack(class_mapping);
                parentEntityName = pc.getSuperclass().getEntityName();
                ExtendedPropertyMapper parentPropertyMapper = this.entitiesConfigurations.get(parentEntityName).getPropertyMapper();
                propertyMapper = new SubclassPropertyMapper(new MultiPropertyMapper(), parentPropertyMapper);
                break;
            }
            case JOINED: {
                throw new MappingException("Joined inheritance strategy not supported for versioning!");
            }
            case TABLE_PER_CLASS: {
                throw new MappingException("Table-per-class inheritance strategy not supported for versioning!");
            }
            default: {
                throw new AssertionError((Object)"Impossible enum value.");
            }
        }
        this.addProperties(class_mapping, pc.getUnjoinedPropertyIterator(), propertyMapper, versioningData, pc.getEntityName(), xmlMappingData, true);
        this.createJoins(pc, class_mapping, versioningData);
        this.addJoins(pc, propertyMapper, versioningData, pc.getEntityName(), xmlMappingData, true);
        EntityConfiguration entityCfg = new EntityConfiguration(versionsEntityName, idMapper, propertyMapper, parentEntityName);
        this.entitiesConfigurations.put(pc.getEntityName(), entityCfg);
    }

    public void generateSecondPass(PersistentClass pc, PersistentClassVersioningData versioningData, EntityXmlMappingData xmlMappingData) {
        String entityName = pc.getEntityName();
        ExtendedPropertyMapper propertyMapper = this.entitiesConfigurations.get(entityName).getPropertyMapper();
        Element parent = xmlMappingData.getMainXmlMapping().getRootElement().element("class");
        if (parent == null) {
            parent = xmlMappingData.getMainXmlMapping().getRootElement().element("subclass");
        }
        this.addProperties(parent, pc.getUnjoinedPropertyIterator(), propertyMapper, versioningData, entityName, xmlMappingData, false);
        this.addJoins(pc, propertyMapper, versioningData, entityName, xmlMappingData, false);
    }

    public Map<String, EntityConfiguration> getEntitiesConfigurations() {
        return this.entitiesConfigurations;
    }

    BasicMetadataGenerator getBasicMetadataGenerator() {
        return this.basicMetadataGenerator;
    }

    Configuration getCfg() {
        return this.cfg;
    }

    GlobalConfiguration getGlobalCfg() {
        return this.globalCfg;
    }

    VersionsEntitiesConfiguration getVerEntCfg() {
        return this.verEntCfg;
    }

    void throwUnsupportedTypeException(Type type, String entityName, String propertyName) {
        String message = "Type not supported for versioning: " + type.getClass().getName() + ", on entity " + entityName + ", property '" + propertyName + "'.";
        if (!this.globalCfg.isWarnOnUnsupportedTypes()) {
            throw new MappingException(message);
        }
        this.log.warn(message);
    }
}

