/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.mapper.id.IdMapper;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.tools.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityInstantiator {
    private final VersionsConfiguration verCfg;
    private final VersionsReaderImplementor versionsReader;

    public EntityInstantiator(VersionsConfiguration verCfg, VersionsReaderImplementor versionsReader) {
        this.verCfg = verCfg;
        this.versionsReader = versionsReader;
    }

    public Object createInstanceFromVersionsEntity(String entityName, Map versionsEntity, Number revision) {
        Object ret;
        if (versionsEntity == null) {
            return null;
        }
        String type = this.verCfg.getEntCfg().getEntityNameForVersionsEntityName((String)versionsEntity.get("$type$"));
        if (type != null) {
            entityName = type;
        }
        IdMapper idMapper = this.verCfg.getEntCfg().get(entityName).getIdMapper();
        Map originalId = (Map)versionsEntity.get(this.verCfg.getVerEntCfg().getOriginalIdPropName());
        Object primaryKey = idMapper.mapToIdFromMap(originalId);
        if (this.versionsReader.getFirstLevelCache().contains(entityName, revision, primaryKey)) {
            return this.versionsReader.getFirstLevelCache().get(entityName, revision, primaryKey);
        }
        try {
            Class<?> cls = ReflectionTools.loadClass(entityName);
            ret = cls.newInstance();
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
        this.versionsReader.getFirstLevelCache().put(entityName, revision, primaryKey, ret);
        this.verCfg.getEntCfg().get(entityName).getPropertyMapper().mapToEntityFromMap(this.verCfg, ret, versionsEntity, primaryKey, this.versionsReader, revision);
        idMapper.mapToEntityFromMap(ret, originalId);
        return ret;
    }

    public void addInstancesFromVersionsEntities(String entityName, Collection addTo, List<Map> versionsEntities, Number revision) {
        for (Map versionsEntity : versionsEntities) {
            addTo.add(this.createInstanceFromVersionsEntity(entityName, versionsEntity, revision));
        }
    }
}

