/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import java.lang.annotation.Annotation;
import javax.persistence.MapKey;
import javax.persistence.Version;
import org.hibernate.MappingException;
import org.hibernate.mapping.PersistentClass;
import org.jboss.envers.SecondaryVersionsTable;
import org.jboss.envers.SecondaryVersionsTables;
import org.jboss.envers.Unversioned;
import org.jboss.envers.Versioned;
import org.jboss.envers.VersionsJoinTable;
import org.jboss.envers.VersionsTable;
import org.jboss.envers.configuration.GlobalConfiguration;
import org.jboss.envers.configuration.metadata.PersistentClassVersioningData;
import org.jboss.envers.tools.reflection.YClass;
import org.jboss.envers.tools.reflection.YProperty;
import org.jboss.envers.tools.reflection.YReflectionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationsMetadataReader {
    private final GlobalConfiguration globalCfg;
    private final YReflectionManager reflectionManager;
    private final PersistentClass pc;
    private final PersistentClassVersioningData versioningData;

    public AnnotationsMetadataReader(GlobalConfiguration globalCfg, YReflectionManager reflectionManager, PersistentClass pc) {
        this.globalCfg = globalCfg;
        this.reflectionManager = reflectionManager;
        this.pc = pc;
        this.versioningData = new PersistentClassVersioningData();
    }

    private void addPropertyVersioned(YProperty property) {
        Versioned ver = property.getAnnotation(Versioned.class);
        if (ver != null) {
            this.versioningData.propertyStoreInfo.propertyStores.put(property.getName(), ver.modStore());
        }
    }

    private void addPropertyMapKey(YProperty property) {
        MapKey mapKey = property.getAnnotation(MapKey.class);
        if (mapKey != null) {
            this.versioningData.mapKeys.put(property.getName(), mapKey.name());
        }
    }

    private void addPropertyUnversioned(YProperty property) {
        Version jpaVer;
        Unversioned unVer = property.getAnnotation(Unversioned.class);
        if (unVer != null) {
            this.versioningData.unversionedProperties.add(property.getName());
        } else if (this.globalCfg.isUnversionedOptimisticLockingField() && (jpaVer = property.getAnnotation(Version.class)) != null) {
            this.versioningData.unversionedProperties.add(property.getName());
        }
    }

    private void addPropertyJoinTables(YProperty property) {
        VersionsJoinTable joinTable = property.getAnnotation(VersionsJoinTable.class);
        if (joinTable != null) {
            this.versioningData.versionsJoinTables.put(property.getName(), joinTable);
        }
    }

    private void addFromProperties(Iterable<YProperty> properties) {
        for (YProperty property : properties) {
            this.addPropertyVersioned(property);
            this.addPropertyUnversioned(property);
            this.addPropertyJoinTables(property);
            this.addPropertyMapKey(property);
        }
    }

    private void addPropertiesFromClass(YClass clazz) {
        YClass superclazz = clazz.getSuperclass();
        if (!"java.lang.Object".equals(superclazz.getName())) {
            this.addPropertiesFromClass(superclazz);
        }
        this.addFromProperties(clazz.getDeclaredProperties("field"));
        this.addFromProperties(clazz.getDeclaredProperties("property"));
    }

    private void addDefaultVersioned(YClass clazz) {
        Versioned defaultVersioned = clazz.getAnnotation(Versioned.class);
        if (defaultVersioned != null) {
            this.versioningData.propertyStoreInfo.defaultStore = defaultVersioned.modStore();
        }
    }

    private void addVersionsTable(YClass clazz) {
        VersionsTable versionsTable = clazz.getAnnotation(VersionsTable.class);
        this.versioningData.versionsTable = versionsTable != null ? versionsTable : this.getDefaultVersionsTable();
    }

    private void addVersionsSecondaryTables(YClass clazz) {
        SecondaryVersionsTables secondaryVersionsTables;
        SecondaryVersionsTable secondaryVersionsTable1 = clazz.getAnnotation(SecondaryVersionsTable.class);
        if (secondaryVersionsTable1 != null) {
            this.versioningData.secondaryTableDictionary.put(secondaryVersionsTable1.secondaryTableName(), secondaryVersionsTable1.secondaryVersionsTableName());
        }
        if ((secondaryVersionsTables = clazz.getAnnotation(SecondaryVersionsTables.class)) != null) {
            for (SecondaryVersionsTable secondaryVersionsTable2 : secondaryVersionsTables.value()) {
                this.versioningData.secondaryTableDictionary.put(secondaryVersionsTable2.secondaryTableName(), secondaryVersionsTable2.secondaryVersionsTableName());
            }
        }
    }

    public PersistentClassVersioningData getVersioningData() {
        if (this.pc.getClassName() == null) {
            return this.versioningData;
        }
        try {
            YClass clazz = this.reflectionManager.classForName(this.pc.getClassName(), this.getClass());
            this.addDefaultVersioned(clazz);
            this.addPropertiesFromClass(clazz);
            this.addVersionsTable(clazz);
            this.addVersionsSecondaryTables(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException((Throwable)e);
        }
        return this.versioningData;
    }

    private VersionsTable getDefaultVersionsTable() {
        return new VersionsTable(){

            @Override
            public String value() {
                return "";
            }

            @Override
            public String schema() {
                return "";
            }

            @Override
            public String catalog() {
                return "";
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return this.getClass();
            }
        };
    }
}

