/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.jboss.envers.configuration.metadata.MetadataTools;
import org.jboss.envers.configuration.metadata.VersionsMetadataGenerator;
import org.jboss.envers.entities.EntityConfiguration;
import org.jboss.envers.entities.IdMappingData;
import org.jboss.envers.entities.mapper.CompositeMapperBuilder;
import org.jboss.envers.entities.mapper.id.IdMapper;
import org.jboss.envers.entities.mapper.relation.OneToOneNotOwningMapper;
import org.jboss.envers.entities.mapper.relation.ToOneIdMapper;

public final class ToOneRelationMetadataGenerator {
    private final VersionsMetadataGenerator mainGenerator;

    ToOneRelationMetadataGenerator(VersionsMetadataGenerator versionsMetadataGenerator) {
        this.mainGenerator = versionsMetadataGenerator;
    }

    void addToOne(Element parent, String name, Value value, CompositeMapperBuilder mapper, String entityName) {
        String referencedEntityName = ((ToOne)value).getReferencedEntityName();
        EntityConfiguration configuration = this.mainGenerator.getEntitiesConfigurations().get(referencedEntityName);
        if (configuration == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + referencedEntityName + "!");
        }
        IdMappingData idMapping = configuration.getIdMappingData();
        String lastPropertyPrefix = name + "_";
        IdMapper relMapper = idMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.mainGenerator.getEntitiesConfigurations().get(entityName).addToOneRelation(name, referencedEntityName, relMapper);
        Element properties = (Element)idMapping.getXmlRelationMapping().clone();
        properties.addAttribute("name", name);
        MetadataTools.prefixNamesInPropertyElement(properties, lastPropertyPrefix, MetadataTools.getColumnNameIterator(value.getColumnIterator()), false);
        parent.add(properties);
        mapper.addComposite(name, new ToOneIdMapper(relMapper, name, referencedEntityName));
    }

    void addOneToOneNotOwning(String name, Value value, CompositeMapperBuilder mapper, String entityName) {
        OneToOne propertyValue = (OneToOne)value;
        String owningReferencePropertyName = propertyValue.getReferencedPropertyName();
        EntityConfiguration configuration = this.mainGenerator.getEntitiesConfigurations().get(entityName);
        if (configuration == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + entityName + "!");
        }
        IdMappingData ownedIdMapping = configuration.getIdMappingData();
        if (ownedIdMapping == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + entityName + "!");
        }
        String lastPropertyPrefix = owningReferencePropertyName + "_";
        String referencedEntityName = propertyValue.getReferencedEntityName();
        IdMapper ownedIdMapper = ownedIdMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.mainGenerator.getEntitiesConfigurations().get(entityName).addToOneNotOwningRelation(name, owningReferencePropertyName, referencedEntityName, ownedIdMapper);
        mapper.addComposite(name, new OneToOneNotOwningMapper(owningReferencePropertyName, referencedEntityName, name));
    }
}

