/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query;

import java.util.Collection;
import org.hibernate.criterion.MatchMode;
import org.jboss.envers.query.criteria.AggregatedFieldVersionsExpression;
import org.jboss.envers.query.criteria.BetweenVersionsExpression;
import org.jboss.envers.query.criteria.IdentifierEqVersionsExpression;
import org.jboss.envers.query.criteria.InVersionsExpression;
import org.jboss.envers.query.criteria.LogicalVersionsExpression;
import org.jboss.envers.query.criteria.NotNullVersionsExpression;
import org.jboss.envers.query.criteria.NotVersionsExpression;
import org.jboss.envers.query.criteria.NullVersionsExpression;
import org.jboss.envers.query.criteria.PropertyVersionsExpression;
import org.jboss.envers.query.criteria.RelatedVersionsExpression;
import org.jboss.envers.query.criteria.SimpleVersionsExpression;
import org.jboss.envers.query.criteria.VersionsConjunction;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.jboss.envers.query.criteria.VersionsDisjunction;

public class VersionsRestrictions {
    private VersionsRestrictions() {
    }

    public static VersionsCriterion idEq(Object value) {
        return new IdentifierEqVersionsExpression(value);
    }

    public static VersionsCriterion eq(String propertyName, Object value) {
        return new SimpleVersionsExpression(propertyName, value, "=");
    }

    public static VersionsCriterion ne(String propertyName, Object value) {
        return new SimpleVersionsExpression(propertyName, value, "<>");
    }

    public static VersionsCriterion relatedIdEq(String propertyName, Object id) {
        return new RelatedVersionsExpression(propertyName, id, true);
    }

    public static VersionsCriterion relatedIdNe(String propertyName, Object id) {
        return new RelatedVersionsExpression(propertyName, id, false);
    }

    public static VersionsCriterion like(String propertyName, Object value) {
        return new SimpleVersionsExpression(propertyName, value, " like ");
    }

    public static VersionsCriterion like(String propertyName, String value, MatchMode matchMode) {
        return new SimpleVersionsExpression(propertyName, matchMode.toMatchString(value), " like ");
    }

    public static VersionsCriterion gt(String propertyName, Object value) {
        return new SimpleVersionsExpression(propertyName, value, ">");
    }

    public static VersionsCriterion lt(String propertyName, Object value) {
        return new SimpleVersionsExpression(propertyName, value, "<");
    }

    public static VersionsCriterion le(String propertyName, Object value) {
        return new SimpleVersionsExpression(propertyName, value, "<=");
    }

    public static VersionsCriterion ge(String propertyName, Object value) {
        return new SimpleVersionsExpression(propertyName, value, ">=");
    }

    public static VersionsCriterion between(String propertyName, Object lo, Object hi) {
        return new BetweenVersionsExpression(propertyName, lo, hi);
    }

    public static VersionsCriterion in(String propertyName, Object[] values) {
        return new InVersionsExpression(propertyName, values);
    }

    public static VersionsCriterion in(String propertyName, Collection values) {
        return new InVersionsExpression(propertyName, values.toArray());
    }

    public static VersionsCriterion isNull(String propertyName) {
        return new NullVersionsExpression(propertyName);
    }

    public static VersionsCriterion eqProperty(String propertyName, String otherPropertyName) {
        return new PropertyVersionsExpression(propertyName, otherPropertyName, "=");
    }

    public static VersionsCriterion neProperty(String propertyName, String otherPropertyName) {
        return new PropertyVersionsExpression(propertyName, otherPropertyName, "<>");
    }

    public static VersionsCriterion ltProperty(String propertyName, String otherPropertyName) {
        return new PropertyVersionsExpression(propertyName, otherPropertyName, "<");
    }

    public static VersionsCriterion leProperty(String propertyName, String otherPropertyName) {
        return new PropertyVersionsExpression(propertyName, otherPropertyName, "<=");
    }

    public static VersionsCriterion gtProperty(String propertyName, String otherPropertyName) {
        return new PropertyVersionsExpression(propertyName, otherPropertyName, ">");
    }

    public static VersionsCriterion geProperty(String propertyName, String otherPropertyName) {
        return new PropertyVersionsExpression(propertyName, otherPropertyName, ">=");
    }

    public static VersionsCriterion isNotNull(String propertyName) {
        return new NotNullVersionsExpression(propertyName);
    }

    public static VersionsCriterion and(VersionsCriterion lhs, VersionsCriterion rhs) {
        return new LogicalVersionsExpression(lhs, rhs, "and");
    }

    public static VersionsCriterion or(VersionsCriterion lhs, VersionsCriterion rhs) {
        return new LogicalVersionsExpression(lhs, rhs, "or");
    }

    public static VersionsCriterion not(VersionsCriterion expression) {
        return new NotVersionsExpression(expression);
    }

    public static VersionsConjunction conjunction() {
        return new VersionsConjunction();
    }

    public static VersionsDisjunction disjunction() {
        return new VersionsDisjunction();
    }

    public static AggregatedFieldVersionsExpression maximizeProperty(String propertyName) {
        return new AggregatedFieldVersionsExpression(propertyName, AggregatedFieldVersionsExpression.AggregatedMode.MAX);
    }

    public static AggregatedFieldVersionsExpression minimizeProperty(String propertyName) {
        return new AggregatedFieldVersionsExpression(propertyName, AggregatedFieldVersionsExpression.AggregatedMode.MIN);
    }
}

