/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.revisioninfo;

import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.property.Setter;
import org.jboss.envers.RevisionListener;
import org.jboss.envers.revisioninfo.RevisionInfoGenerator;
import org.jboss.envers.tools.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRevisionInfoGenerator
implements RevisionInfoGenerator {
    private final String revisionInfoEntityName;
    private final RevisionListener listener;
    private final Setter revisionTimestampSetter;
    private final Class<?> revisionInfoClass;

    public DefaultRevisionInfoGenerator(String revisionInfoEntityName, Class<?> revisionInfoClass, Class<? extends RevisionListener> listenerClass, String revisionInfoTimestampName) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.revisionInfoClass = revisionInfoClass;
        this.revisionTimestampSetter = ReflectionTools.getSetter(revisionInfoClass, revisionInfoTimestampName);
        if (!listenerClass.equals(RevisionListener.class)) {
            try {
                this.listener = listenerClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new MappingException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new MappingException((Throwable)e);
            }
        } else {
            this.listener = null;
        }
    }

    private Object newRevision() {
        Object revisionInfo;
        try {
            revisionInfo = this.revisionInfoClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.revisionTimestampSetter.set(revisionInfo, (Object)System.currentTimeMillis(), null);
        if (this.listener != null) {
            this.listener.newRevision(revisionInfo);
        }
        return revisionInfo;
    }

    @Override
    public Object generate(Session session) {
        Object revisionData = this.newRevision();
        session.save(this.revisionInfoEntityName, revisionData);
        return revisionData;
    }
}

