/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.type.BagType;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CustomType;
import org.hibernate.type.ImmutableType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.MutableType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.SetType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;
import org.jboss.envers.ModificationStore;
import org.jboss.envers.configuration.GlobalConfiguration;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.configuration.metadata.EntityMappingData;
import org.jboss.envers.configuration.metadata.InheritanceType;
import org.jboss.envers.configuration.metadata.MetadataTools;
import org.jboss.envers.configuration.metadata.PersistentClassVersioningData;
import org.jboss.envers.configuration.metadata.PropertyStoreInfo;
import org.jboss.envers.entities.EntityConfiguration;
import org.jboss.envers.entities.IdMappingData;
import org.jboss.envers.entities.mapper.CompositeMapperBuilder;
import org.jboss.envers.entities.mapper.ExtendedPropertyMapper;
import org.jboss.envers.entities.mapper.MultiPropertyMapper;
import org.jboss.envers.entities.mapper.SimpleMapperBuilder;
import org.jboss.envers.entities.mapper.SubclassPropertyMapper;
import org.jboss.envers.entities.mapper.id.AbstractIdMapper;
import org.jboss.envers.entities.mapper.id.EmbeddedIdMapper;
import org.jboss.envers.entities.mapper.id.IdMapper;
import org.jboss.envers.entities.mapper.id.MultipleIdMapper;
import org.jboss.envers.entities.mapper.id.SingleIdMapper;
import org.jboss.envers.entities.mapper.relation.ManyToManyNotOwningMapper;
import org.jboss.envers.entities.mapper.relation.OneToManyAttachedMapper;
import org.jboss.envers.entities.mapper.relation.OneToManyDetachedMapper;
import org.jboss.envers.entities.mapper.relation.OneToOneNotOwningIdMapper;
import org.jboss.envers.entities.mapper.relation.ToOneIdMapper;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.tools.HibernateVersion;
import org.jboss.envers.tools.StringTools;
import org.jboss.envers.tools.Tools;
import org.jboss.envers.tools.log.YLog;
import org.jboss.envers.tools.log.YLogManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionsMetadataGenerator {
    private static final Map<String, ModificationStore> EMPTY_STORE = Collections.emptyMap();
    private final Configuration cfg;
    private final GlobalConfiguration globalCfg;
    private final VersionsEntitiesConfiguration verEntCfg;
    private final Element revisionInfoRelationMapping;
    private Map<String, EntityConfiguration> entitiesConfigurations;
    private Map<String, Map<Join, Element>> entitiesJoins;
    private YLog log = YLogManager.getLogManager().getLog(VersionsMetadataGenerator.class);

    public VersionsMetadataGenerator(Configuration cfg, GlobalConfiguration globalCfg, VersionsEntitiesConfiguration verEntCfg, Element revisionInfoRelationMapping) {
        this.cfg = cfg;
        this.globalCfg = globalCfg;
        this.verEntCfg = verEntCfg;
        this.revisionInfoRelationMapping = revisionInfoRelationMapping;
        this.entitiesConfigurations = new HashMap<String, EntityConfiguration>();
        this.entitiesJoins = new HashMap<String, Map<Join, Element>>();
    }

    private void addComponentClassName(Element any_mapping, Component comp) {
        if (StringHelper.isNotEmpty((String)comp.getComponentClassName())) {
            any_mapping.addAttribute("class", comp.getComponentClassName());
        }
    }

    private void addColumns(Element any_mapping, Iterator<Column> columns) {
        while (columns.hasNext()) {
            Column column = columns.next();
            MetadataTools.addColumn(any_mapping, column.getName(), column.getLength());
        }
    }

    private void addRevisionInfoRelation(Element any_mapping) {
        Element rev_mapping = (Element)this.revisionInfoRelationMapping.clone();
        rev_mapping.addAttribute("name", this.verEntCfg.getRevisionPropName());
        MetadataTools.addColumn(rev_mapping, this.verEntCfg.getRevisionPropName(), null);
        any_mapping.add(rev_mapping);
    }

    private void addRevisionType(Element any_mapping) {
        Element revTypeProperty = MetadataTools.addProperty(any_mapping, this.verEntCfg.getRevisionTypePropName(), this.verEntCfg.getRevisionTypePropType(), false);
        revTypeProperty.addAttribute("type", "org.jboss.envers.entities.RevisionTypeType");
    }

    private void addSimpleProperty(Element parent, Property property, SimpleMapperBuilder mapper, ModificationStore store, boolean key) {
        Element prop_mapping = MetadataTools.addProperty(parent, property.getName(), property.getType().getName(), key);
        this.addColumns(prop_mapping, property.getColumnIterator());
        if (mapper != null) {
            mapper.add(property.getName(), store);
        }
    }

    private void addEnumProperty(Element parent, Property property, SimpleMapperBuilder mapper, ModificationStore store) {
        Element prop_mapping = parent.addElement("property");
        prop_mapping.addAttribute("name", property.getName());
        CustomType propertyType = (CustomType)property.getType();
        Element type_mapping = prop_mapping.addElement("type");
        type_mapping.addAttribute("name", propertyType.getName());
        Element type_param1 = type_mapping.addElement("param");
        type_param1.addAttribute("name", "enumClass");
        type_param1.setText(propertyType.getReturnedClass().getName());
        Element type_param2 = type_mapping.addElement("param");
        type_param2.addAttribute("name", "type");
        type_param2.setText(Integer.toString(propertyType.sqlTypes(null)[0]));
        this.addColumns(prop_mapping, property.getColumnIterator());
        mapper.add(property.getName(), store);
    }

    private void addComponent(Element parent, Property property, CompositeMapperBuilder mapper, ModificationStore store, String entityName, EntityMappingData mappingData, List<String> unversionedProperties, boolean firstPass) {
        Element component_mapping = null;
        Component prop_component = (Component)property.getValue();
        if (!firstPass) {
            Iterator iter = parent.elementIterator("component");
            while (iter.hasNext()) {
                Element child = (Element)iter.next();
                if (!child.attribute("name").getText().equals(property.getName())) continue;
                component_mapping = child;
                break;
            }
            if (component_mapping == null) {
                throw new VersionsException("Element for component not found during second pass!");
            }
        } else {
            component_mapping = parent.addElement("component");
            component_mapping.addAttribute("name", property.getName());
            this.addComponentClassName(component_mapping, prop_component);
        }
        this.addProperties(component_mapping, prop_component.getPropertyIterator(), mapper.addComposite(property.getName()), new PropertyStoreInfo(store, EMPTY_STORE), entityName, mappingData, unversionedProperties, firstPass);
    }

    private void changeNamesInColumnElement(Element element, Iterator<Column> columnIterator) {
        Iterator properties = element.elementIterator();
        while (properties.hasNext()) {
            Attribute nameAttr;
            Element property = (Element)properties.next();
            if (!"column".equals(property.getName()) || (nameAttr = property.attribute("name")) == null) continue;
            nameAttr.setText(columnIterator.next().getName());
        }
    }

    private void prefixNamesInPropertyElement(Element element, String prefix, Iterator<Column> columnIterator, boolean changeToKey) {
        Iterator properties = element.elementIterator();
        while (properties.hasNext()) {
            Element property = (Element)properties.next();
            if (!"property".equals(property.getName())) continue;
            Attribute nameAttr = property.attribute("name");
            if (nameAttr != null) {
                nameAttr.setText(prefix + nameAttr.getText());
            }
            this.changeNamesInColumnElement(property, columnIterator);
            if (!changeToKey) continue;
            property.setName("key-property");
        }
    }

    private void addToOne(Element parent, Property property, CompositeMapperBuilder mapper, String entityName) {
        String referencedEntityName = ((ToOne)property.getValue()).getReferencedEntityName();
        EntityConfiguration configuration = this.entitiesConfigurations.get(referencedEntityName);
        if (configuration == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + referencedEntityName + "!");
        }
        IdMappingData idMapping = configuration.getIdMappingData();
        String propertyName = property.getName();
        String lastPropertyPrefix = propertyName + "_";
        IdMapper relMapper = idMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.entitiesConfigurations.get(entityName).addToOneRelation(propertyName, referencedEntityName, relMapper);
        Element properties = (Element)idMapping.getXmlRelationMapping().clone();
        properties.addAttribute("name", propertyName);
        this.prefixNamesInPropertyElement(properties, lastPropertyPrefix, property.getValue().getColumnIterator(), false);
        parent.add(properties);
        mapper.addComposite(propertyName, new ToOneIdMapper(relMapper, propertyName, referencedEntityName));
    }

    private void addOneToOneNotOwning(Property property, CompositeMapperBuilder mapper, String entityName) {
        OneToOne propertyValue = (OneToOne)property.getValue();
        String owningReferencePropertyName = propertyValue.getReferencedPropertyName();
        EntityConfiguration configuration = this.entitiesConfigurations.get(entityName);
        if (configuration == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + entityName + "!");
        }
        IdMappingData ownedIdMapping = configuration.getIdMappingData();
        if (ownedIdMapping == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + entityName + "!");
        }
        String propertyName = property.getName();
        String lastPropertyPrefix = owningReferencePropertyName + "_";
        String referencedEntityName = propertyValue.getReferencedEntityName();
        IdMapper ownedIdMapper = ownedIdMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.entitiesConfigurations.get(entityName).addOneToOneNotOwningRelation(propertyName, owningReferencePropertyName, referencedEntityName, ownedIdMapper);
        mapper.addComposite(propertyName, new OneToOneNotOwningIdMapper(owningReferencePropertyName, referencedEntityName, propertyName));
    }

    private String getMappedBy(Collection collectionValue) {
        Iterator assocClassProps = ((OneToMany)collectionValue.getElement()).getAssociatedClass().getPropertyIterator();
        while (assocClassProps.hasNext()) {
            Property property = (Property)assocClassProps.next();
            if (!Tools.iteratorsContentEqual(property.getValue().getColumnIterator(), collectionValue.getKey().getColumnIterator())) continue;
            return property.getName();
        }
        return null;
    }

    private void addOneToManyAttached(Property property, CompositeMapperBuilder mapper, String entityName) {
        Collection propertyValue = (Collection)property.getValue();
        String owningReferencePropertyName = this.getMappedBy(propertyValue);
        if (owningReferencePropertyName == null) {
            throw new MappingException("Unable to read the mapped by attribute for " + property.getName());
        }
        EntityConfiguration configuration = this.entitiesConfigurations.get(entityName);
        if (configuration == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + entityName + "!");
        }
        IdMappingData referencingIdMapping = configuration.getIdMappingData();
        String owningEntityName = ((OneToMany)propertyValue.getElement()).getReferencedEntityName();
        String propertyName = property.getName();
        String lastPropertyPrefix = owningReferencePropertyName + "_";
        IdMapper ownedIdMapper = referencingIdMapping.getIdMapper().prefixMappedProperties(lastPropertyPrefix);
        this.entitiesConfigurations.get(entityName).addOneToManyAttachedRelation(propertyName, owningReferencePropertyName, owningEntityName, ownedIdMapper);
        mapper.addComposite(propertyName, new OneToManyAttachedMapper(owningReferencePropertyName, owningEntityName, propertyName));
    }

    private String getMiddleEntityName(String entityName, String referencedEntityName, ManyToOne mto) {
        return entityName + "_" + referencedEntityName + "_" + mto.getTable().getName();
    }

    private void addOneToManyDetached(Property property, CompositeMapperBuilder mapper, String entityName, EntityMappingData mappingData) {
        Collection propertyValue = (Collection)property.getValue();
        ManyToOne mto = (ManyToOne)propertyValue.getElement();
        String referencedEntityName = mto.getReferencedEntityName();
        EntityConfiguration configuration = this.entitiesConfigurations.get(entityName);
        if (configuration == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + entityName + "!");
        }
        EntityConfiguration referencedConfiguration = this.entitiesConfigurations.get(referencedEntityName);
        if (referencedConfiguration == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + referencedEntityName + "!");
        }
        IdMappingData referencingIdMapping = configuration.getIdMappingData();
        IdMappingData referencedIdMapping = referencedConfiguration.getIdMappingData();
        String referencingPrefix = StringTools.getLastComponent(entityName) + "_";
        String referencedPrefix = property.getName() + "_";
        String middleEntityName = this.getMiddleEntityName(entityName, referencedEntityName, mto);
        String versionsMiddleEntityName = this.verEntCfg.getVersionsEntityName(middleEntityName);
        String versionsMiddleTableName = this.verEntCfg.getVersionsTableName(middleEntityName, mto.getTable().getName());
        Element middleEntity = MetadataTools.createEntity(mappingData.newAdditionalMapping(), versionsMiddleEntityName, versionsMiddleTableName, mto.getTable().getSchema(), mto.getTable().getCatalog(), null);
        Element middleEntityId = middleEntity.addElement("composite-id");
        middleEntityId.addAttribute("name", this.verEntCfg.getOriginalIdPropName());
        Iterator columnIterator = mto.getTable().getColumnIterator();
        Element properties = (Element)referencingIdMapping.getXmlRelationMapping().clone();
        this.prefixNamesInPropertyElement(properties, referencingPrefix, columnIterator, true);
        for (Element idProperty : properties.elements()) {
            middleEntityId.add((Element)idProperty.clone());
        }
        properties = (Element)referencedIdMapping.getXmlRelationMapping().clone();
        this.prefixNamesInPropertyElement(properties, referencedPrefix, columnIterator, true);
        for (Element idProperty : properties.elements()) {
            middleEntityId.add((Element)idProperty.clone());
        }
        this.addRevisionInfoRelation(middleEntityId);
        this.addRevisionType(middleEntity);
        this.entitiesConfigurations.get(entityName).addOneToManyDetachedRelation(property.getName(), referencedEntityName);
        mapper.addComposite(property.getName(), new OneToManyDetachedMapper(this.verEntCfg, entityName, referencedEntityName, property.getName(), this.verEntCfg.getVersionsEntityName(referencedEntityName), versionsMiddleEntityName, referencingIdMapping.getIdMapper().prefixMappedProperties(referencingPrefix), referencedIdMapping.getIdMapper().prefixMappedProperties(referencedPrefix), this.entitiesConfigurations.get(referencedEntityName).getIdMapper()));
    }

    private String getMappedBy(Table collectionTable, PersistentClass referencedClass) {
        Iterator properties = referencedClass.getPropertyIterator();
        while (properties.hasNext()) {
            Property property = (Property)properties.next();
            if (!(property.getValue() instanceof Collection) || ((Collection)property.getValue()).getCollectionTable() != collectionTable) continue;
            return property.getName();
        }
        return null;
    }

    private void addManyToManyNotOwning(Property property, CompositeMapperBuilder mapper, String entityName) {
        Collection propertyValue = (Collection)property.getValue();
        ManyToOne mto = (ManyToOne)propertyValue.getElement();
        String referencedEntityName = mto.getReferencedEntityName();
        EntityConfiguration configuration = this.entitiesConfigurations.get(entityName);
        if (configuration == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + entityName + "!");
        }
        EntityConfiguration referencedConfiguration = this.entitiesConfigurations.get(referencedEntityName);
        if (referencedConfiguration == null) {
            throw new MappingException("A versioned relation to a non-versioned entity " + referencedEntityName + "!");
        }
        String mappedBy = this.getMappedBy(propertyValue.getCollectionTable(), this.cfg.getClassMapping(referencedEntityName));
        if (mappedBy == null) {
            throw new MappingException("Unable to read the mapped by attribute for " + property.getName());
        }
        IdMappingData referencingIdMapping = configuration.getIdMappingData();
        IdMappingData referencedIdMapping = referencedConfiguration.getIdMappingData();
        String referencingPrefix = mappedBy + "_";
        String referencedPrefix = StringTools.getLastComponent(referencedEntityName) + "_";
        String middleEntityName = this.getMiddleEntityName(referencedEntityName, entityName, mto);
        String versionsMiddleEntityName = this.verEntCfg.getVersionsEntityName(middleEntityName);
        this.entitiesConfigurations.get(entityName).addManyToManyNotOwningRelation(property.getName(), mappedBy, referencedEntityName);
        mapper.addComposite(property.getName(), new ManyToManyNotOwningMapper(this.verEntCfg, entityName, referencedEntityName, property.getName(), this.verEntCfg.getVersionsEntityName(referencedEntityName), versionsMiddleEntityName, referencingIdMapping.getIdMapper().prefixMappedProperties(referencingPrefix), referencedIdMapping.getIdMapper().prefixMappedProperties(referencedPrefix), this.entitiesConfigurations.get(referencedEntityName).getIdMapper()));
    }

    private ModificationStore getStoreForProperty(Property property, PropertyStoreInfo propertyStoreInfo, List<String> unversionedProperties) {
        if (unversionedProperties.contains(property.getName())) {
            return null;
        }
        ModificationStore store = propertyStoreInfo.propertyStores.get(property.getName());
        if (store == null) {
            return propertyStoreInfo.defaultStore;
        }
        return store;
    }

    private void addIdProperties(Element parent, Iterator<Property> properties, SimpleMapperBuilder mapper, boolean key) {
        while (properties.hasNext()) {
            Property property = properties.next();
            Type propertyType = property.getType();
            if ("_identifierMapper".equals(property.getName())) continue;
            if (propertyType instanceof ImmutableType) {
                this.addSimpleProperty(parent, property, mapper, ModificationStore.FULL, key);
                continue;
            }
            throw new MappingException("Type not supported: " + propertyType.getClass().getName());
        }
    }

    private void addProperties(Element parent, Iterator<Property> properties, CompositeMapperBuilder currentMapper, PropertyStoreInfo propertyStoreInfo, String entityName, EntityMappingData mappingData, List<String> unversionedProperties, boolean firstPass) {
        while (properties.hasNext()) {
            ModificationStore store;
            Property property = properties.next();
            Type propertyType = property.getType();
            if ("_identifierMapper".equals(property.getName()) || (store = this.getStoreForProperty(property, propertyStoreInfo, unversionedProperties)) == null) continue;
            if (propertyType instanceof ComponentType) {
                if (!firstPass) continue;
                this.addComponent(parent, property, currentMapper, store, entityName, mappingData, unversionedProperties, firstPass);
                continue;
            }
            if (propertyType instanceof ImmutableType || propertyType instanceof MutableType) {
                if (!firstPass) continue;
                this.addSimpleProperty(parent, property, currentMapper, store, false);
                continue;
            }
            if (propertyType instanceof CustomType && "org.hibernate.type.EnumType".equals(propertyType.getName())) {
                if (!firstPass) continue;
                this.addEnumProperty(parent, property, currentMapper, store);
                continue;
            }
            if (propertyType instanceof ManyToOneType) {
                if (firstPass) continue;
                this.addToOne(parent, property, currentMapper, entityName);
                continue;
            }
            if (propertyType instanceof OneToOneType) {
                if (firstPass) continue;
                this.addOneToOneNotOwning(property, currentMapper, entityName);
                continue;
            }
            if ("org.hibernate.type.PrimitiveByteArrayBlobType".equals(propertyType.getClass().getName())) {
                if (!firstPass) continue;
                this.addSimpleProperty(parent, property, currentMapper, store, false);
                continue;
            }
            if (propertyType instanceof CustomType && ("org.hibernate.type.PrimitiveCharacterArrayClobType".equals(propertyType.getName()) || "org.hibernate.type.StringClobType".equals(propertyType.getName()))) {
                if (!firstPass) continue;
                this.addSimpleProperty(parent, property, currentMapper, store, false);
                continue;
            }
            if ((propertyType instanceof BagType || propertyType instanceof SetType) && ((Collection)property.getValue()).getElement() instanceof OneToMany) {
                if (firstPass) continue;
                this.addOneToManyAttached(property, currentMapper, entityName);
                continue;
            }
            if ((propertyType instanceof BagType || propertyType instanceof SetType) && ((Collection)property.getValue()).getElement() instanceof ManyToOne && !((Collection)property.getValue()).isInverse()) {
                if (firstPass) continue;
                this.addOneToManyDetached(property, currentMapper, entityName, mappingData);
                continue;
            }
            if ((propertyType instanceof BagType || propertyType instanceof SetType) && ((Collection)property.getValue()).getElement() instanceof ManyToOne && ((Collection)property.getValue()).isInverse()) {
                if (firstPass) continue;
                this.addManyToManyNotOwning(property, currentMapper, entityName);
                continue;
            }
            String message = "Type not supported for versioning: " + propertyType.getClass().getName() + ", on entity " + entityName + ", property '" + property.getName() + "'.";
            if (this.globalCfg.isWarnOnUnsupportedTypes()) {
                this.log.warn(message);
                continue;
            }
            throw new MappingException(message);
        }
    }

    private void createJoins(PersistentClass pc, Element parent, PersistentClassVersioningData versioningData) {
        Iterator joins = pc.getJoinIterator();
        HashMap<Join, Element> joinElements = new HashMap<Join, Element>();
        this.entitiesJoins.put(pc.getEntityName(), joinElements);
        while (joins.hasNext()) {
            String catalog;
            String schema;
            Join join = (Join)joins.next();
            String originalTableName = join.getTable().getName();
            String versionedTableName = versioningData.secondaryTableDictionary.get(originalTableName);
            if (versionedTableName == null) {
                versionedTableName = this.verEntCfg.getVersionsEntityName(originalTableName);
            }
            if (StringTools.isEmpty(schema = versioningData.schema)) {
                schema = join.getTable().getSchema();
            }
            if (StringTools.isEmpty(catalog = versioningData.catalog)) {
                catalog = join.getTable().getCatalog();
            }
            Element joinElement = MetadataTools.createJoin(parent, versionedTableName, schema, catalog);
            joinElements.put(join, joinElement);
            Element joinKey = joinElement.addElement("key");
            this.addColumns(joinKey, join.getKey().getColumnIterator());
            MetadataTools.addColumn(joinKey, this.verEntCfg.getRevisionPropName(), null);
        }
    }

    private void addJoins(PersistentClass pc, CompositeMapperBuilder currentMapper, PropertyStoreInfo propertyStoreInfo, String entityName, EntityMappingData mappingData, List<String> unversionedProperties, boolean firstPass) {
        Iterator joins = pc.getJoinIterator();
        while (joins.hasNext()) {
            Join join = (Join)joins.next();
            Element joinElement = this.entitiesJoins.get(entityName).get(join);
            this.addProperties(joinElement, join.getPropertyIterator(), currentMapper, propertyStoreInfo, entityName, mappingData, unversionedProperties, firstPass);
        }
    }

    private IdMappingData addId(PersistentClass pc) {
        AbstractIdMapper mapper;
        DefaultElement rel_id_mapping = new DefaultElement("properties");
        DefaultElement orig_id_mapping = new DefaultElement("composite-id");
        Property id_prop = pc.getIdentifierProperty();
        Component id_mapper = pc.getIdentifierMapper();
        if (id_mapper != null) {
            mapper = new MultipleIdMapper(((Component)pc.getIdentifier()).getComponentClassName());
            this.addIdProperties((Element)rel_id_mapping, id_mapper.getPropertyIterator(), (SimpleMapperBuilder)((Object)mapper), false);
            this.addIdProperties((Element)orig_id_mapping, id_mapper.getPropertyIterator(), null, true);
        } else if (id_prop.isComposite()) {
            Component id_component = (Component)id_prop.getValue();
            mapper = new EmbeddedIdMapper(id_prop.getName(), id_component.getComponentClassName());
            this.addIdProperties((Element)rel_id_mapping, id_component.getPropertyIterator(), (SimpleMapperBuilder)((Object)mapper), false);
            this.addIdProperties((Element)orig_id_mapping, id_component.getPropertyIterator(), null, true);
        } else {
            mapper = new SingleIdMapper();
            this.addSimpleProperty((Element)rel_id_mapping, id_prop, (SimpleMapperBuilder)((Object)mapper), ModificationStore.FULL, false);
            this.addSimpleProperty((Element)orig_id_mapping, id_prop, null, ModificationStore.FULL, true);
        }
        orig_id_mapping.addAttribute("name", this.verEntCfg.getOriginalIdPropName());
        this.addRevisionInfoRelation((Element)orig_id_mapping);
        return new IdMappingData(mapper, (Element)orig_id_mapping, (Element)rel_id_mapping);
    }

    private void addPersisterHack(Element class_mapping) {
        String persisterClassName = HibernateVersion.get().startsWith("3.3") ? "org.jboss.envers.entity.VersionsInheritanceEntityPersisterFor33" : "org.jboss.envers.entity.VersionsInheritanceEntityPersisterFor32";
        class_mapping.addAttribute("persister", persisterClassName);
    }

    public void generateFirstPass(PersistentClass pc, PersistentClassVersioningData versioningData, EntityMappingData mappingData) {
        ExtendedPropertyMapper propertyMapper;
        Element class_mapping;
        String catalog;
        String schema = versioningData.schema;
        if (StringTools.isEmpty(schema)) {
            schema = pc.getTable().getSchema();
        }
        if (StringTools.isEmpty(catalog = versioningData.catalog)) {
            catalog = pc.getTable().getCatalog();
        }
        String entityName = pc.getEntityName();
        String versionsEntityName = this.verEntCfg.getVersionsEntityName(entityName);
        String versionsTableName = this.verEntCfg.getVersionsTableName(entityName, pc.getTable().getName());
        IdMappingData idMapper = this.addId(pc);
        InheritanceType inheritanceType = InheritanceType.get(pc);
        String parentEntityName = null;
        switch (inheritanceType) {
            case NONE: {
                class_mapping = MetadataTools.createEntity(mappingData.getMainMapping(), versionsEntityName, versionsTableName, schema, catalog, pc.getDiscriminatorValue());
                propertyMapper = new MultiPropertyMapper();
                if (pc.getDiscriminator() != null) {
                    Element discriminator_element = class_mapping.addElement("discriminator");
                    this.addColumns(discriminator_element, pc.getDiscriminator().getColumnIterator());
                    discriminator_element.addAttribute("type", pc.getDiscriminator().getType().getName());
                    this.addPersisterHack(class_mapping);
                }
                class_mapping.add((Element)idMapper.getXmlMapping().clone());
                this.addRevisionType(class_mapping);
                break;
            }
            case SINGLE: {
                String extendsEntityName = this.verEntCfg.getVersionsEntityName(pc.getSuperclass().getEntityName());
                class_mapping = MetadataTools.createSubclassEntity(mappingData.getMainMapping(), versionsEntityName, versionsTableName, schema, catalog, extendsEntityName, pc.getDiscriminatorValue());
                this.addPersisterHack(class_mapping);
                parentEntityName = pc.getSuperclass().getEntityName();
                ExtendedPropertyMapper parentPropertyMapper = this.entitiesConfigurations.get(parentEntityName).getPropertyMapper();
                propertyMapper = new SubclassPropertyMapper(new MultiPropertyMapper(), parentPropertyMapper);
                break;
            }
            case JOINED: {
                throw new MappingException("Joined inheritance strategy not supported for versioning!");
            }
            case TABLE_PER_CLASS: {
                throw new MappingException("Table-per-class inheritance strategy not supported for versioning!");
            }
            default: {
                throw new AssertionError((Object)"Impossible enum value.");
            }
        }
        this.addProperties(class_mapping, pc.getUnjoinedPropertyIterator(), propertyMapper, versioningData.propertyStoreInfo, pc.getEntityName(), mappingData, versioningData.unversionedProperties, true);
        this.createJoins(pc, class_mapping, versioningData);
        this.addJoins(pc, propertyMapper, versioningData.propertyStoreInfo, pc.getEntityName(), mappingData, versioningData.unversionedProperties, true);
        EntityConfiguration entityCfg = new EntityConfiguration(entityName, versionsEntityName, idMapper, propertyMapper, parentEntityName);
        this.entitiesConfigurations.put(pc.getEntityName(), entityCfg);
    }

    public void generateSecondPass(PersistentClass pc, PersistentClassVersioningData versioningData, EntityMappingData mappingData) {
        String entityName = pc.getEntityName();
        ExtendedPropertyMapper propertyMapper = this.entitiesConfigurations.get(entityName).getPropertyMapper();
        Element parent = mappingData.getMainMapping().getRootElement().element("class");
        if (parent == null) {
            parent = mappingData.getMainMapping().getRootElement().element("subclass");
        }
        this.addProperties(parent, pc.getUnjoinedPropertyIterator(), propertyMapper, versioningData.propertyStoreInfo, entityName, mappingData, versioningData.unversionedProperties, false);
        this.addJoins(pc, propertyMapper, versioningData.propertyStoreInfo, entityName, mappingData, versioningData.unversionedProperties, false);
    }

    public Map<String, EntityConfiguration> getEntitiesConfigurations() {
        return this.entitiesConfigurations;
    }
}

