/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities;

import java.util.HashMap;
import java.util.Map;
import org.jboss.envers.entities.IdMappingData;
import org.jboss.envers.entities.RelationDescription;
import org.jboss.envers.entities.RelationType;
import org.jboss.envers.entities.mapper.ExtendedPropertyMapper;
import org.jboss.envers.entities.mapper.id.IdMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityConfiguration {
    private String entityName;
    private String versionsEntityName;
    private IdMappingData idMappingData;
    private ExtendedPropertyMapper propertyMapper;
    private Map<String, RelationDescription> relations;
    private String parentEntityName;

    public EntityConfiguration(String entityName, String versionsEntityName, IdMappingData idMappingData, ExtendedPropertyMapper propertyMapper, String parentEntityName) {
        this.entityName = entityName;
        this.versionsEntityName = versionsEntityName;
        this.idMappingData = idMappingData;
        this.propertyMapper = propertyMapper;
        this.parentEntityName = parentEntityName;
        this.relations = new HashMap<String, RelationDescription>();
    }

    public void addToOneRelation(String fromPropertyName, String toEntityName, IdMapper idMapper) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.TO_ONE, toEntityName, null, idMapper));
    }

    public void addOneToOneNotOwningRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName, IdMapper idMapper) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.ONE_TO_ONE, toEntityName, mappedByPropertyName, idMapper));
    }

    public void addOneToManyAttachedRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName, IdMapper idMapper) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.ONE_TO_MANY, toEntityName, mappedByPropertyName, idMapper));
    }

    public void addOneToManyDetachedRelation(String fromPropertyName, String toEntityName) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.ONE_TO_MANY_DETACHED, toEntityName, null, null));
    }

    public void addManyToManyNotOwningRelation(String fromPropertyName, String mappedByPropertyName, String toEntityName) {
        this.relations.put(fromPropertyName, new RelationDescription(fromPropertyName, RelationType.MANY_TO_MANY_NOT_OWNING, toEntityName, mappedByPropertyName, null));
    }

    public boolean isRelation(String propertyName) {
        return this.relations.get(propertyName) != null;
    }

    public RelationDescription getRelationDescription(String propertyName) {
        return this.relations.get(propertyName);
    }

    public IdMappingData getIdMappingData() {
        return this.idMappingData;
    }

    public IdMapper getIdMapper() {
        return this.idMappingData.getIdMapper();
    }

    public ExtendedPropertyMapper getPropertyMapper() {
        return this.propertyMapper;
    }

    public String getEntityName() {
        return this.entityName;
    }

    String getParentEntityName() {
        return this.parentEntityName;
    }

    String getVersionsEntityName() {
        return this.versionsEntityName;
    }

    Iterable<RelationDescription> getRelationsIterator() {
        return this.relations.values();
    }
}

