/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.property.Setter;
import org.jboss.envers.ModificationStore;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.mapper.PersistentCollectionChangeData;
import org.jboss.envers.entities.mapper.PropertyMapper;
import org.jboss.envers.entities.mapper.SimpleMapperBuilder;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.tools.Tools;
import org.jboss.envers.tools.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePropertyMapper
implements PropertyMapper,
SimpleMapperBuilder {
    private String propertyName;

    public SinglePropertyMapper(String propertyName, ModificationStore modStore) {
        this.propertyName = propertyName;
    }

    public SinglePropertyMapper() {
    }

    @Override
    public void add(String propertyName, ModificationStore modStore) {
        if (this.propertyName != null) {
            throw new VersionsException("Only one property can be added!");
        }
        this.propertyName = propertyName;
    }

    @Override
    public boolean mapToMapFromEntity(Map<String, Object> data, Object newObj, Object oldObj) {
        data.put(this.propertyName, newObj);
        return !Tools.objectsEqual(newObj, oldObj);
    }

    @Override
    public void mapToEntityFromMap(VersionsConfiguration verCfg, Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        if (data == null || obj == null) {
            return;
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyName);
        setter.set(obj, data.get(this.propertyName), null);
    }

    @Override
    public List<PersistentCollectionChangeData> mapCollectionChanges(String referencingPropertyName, PersistentCollection newColl, Serializable oldColl, Serializable id) {
        return null;
    }
}

