/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.id;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.hibernate.util.ReflectHelper;
import org.jboss.envers.entities.mapper.id.AbstractCompositeIdMapper;
import org.jboss.envers.entities.mapper.id.IdMapper;
import org.jboss.envers.entities.mapper.id.QueryParameterData;
import org.jboss.envers.entities.mapper.id.SimpleIdMapperBuilder;
import org.jboss.envers.entities.mapper.id.SingleIdMapper;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.tools.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedIdMapper
extends AbstractCompositeIdMapper
implements SimpleIdMapperBuilder {
    private String idPropertyName;

    public EmbeddedIdMapper(String idPropertyName, String compositeIdClass) {
        super(compositeIdClass);
        this.idPropertyName = idPropertyName;
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        for (SingleIdMapper idMapper : this.ids.values()) {
            idMapper.mapToMapFromEntity(data, obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        if (obj == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.idPropertyName);
        this.mapToMapFromId(data, getter.get(obj));
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data) {
        if (data == null || obj == null) {
            return;
        }
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.idPropertyName);
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.idPropertyName);
        try {
            Object subObj = ReflectHelper.getDefaultConstructor((Class)getter.getReturnType()).newInstance(new Object[0]);
            setter.set(obj, subObj, null);
            for (SingleIdMapper idMapper : this.ids.values()) {
                idMapper.mapToEntityFromMap(subObj, data);
            }
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        EmbeddedIdMapper ret = new EmbeddedIdMapper(this.idPropertyName, this.compositeIdClass);
        for (String propertyName : this.ids.keySet()) {
            ret.ids.put(propertyName, new SingleIdMapper(propertyName, prefix + propertyName));
        }
        return ret;
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        if (data == null) {
            return null;
        }
        Getter getter = ReflectionTools.getGetter(data.getClass(), this.idPropertyName);
        return getter.get(data);
    }

    @Override
    public List<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        this.mapToMapFromId(data, obj);
        ArrayList<QueryParameterData> ret = new ArrayList<QueryParameterData>();
        for (String propertyName : data.keySet()) {
            ret.add(new QueryParameterData(propertyName, data.get(propertyName)));
        }
        return ret;
    }
}

