/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.id;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.envers.entities.mapper.id.AbstractCompositeIdMapper;
import org.jboss.envers.entities.mapper.id.IdMapper;
import org.jboss.envers.entities.mapper.id.QueryParameterData;
import org.jboss.envers.entities.mapper.id.SimpleIdMapperBuilder;
import org.jboss.envers.entities.mapper.id.SingleIdMapper;
import org.jboss.envers.exception.VersionsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleIdMapper
extends AbstractCompositeIdMapper
implements SimpleIdMapperBuilder {
    public MultipleIdMapper(String compositeIdClass) {
        super(compositeIdClass);
    }

    @Override
    public void mapToMapFromId(Map<String, Object> data, Object obj) {
        for (SingleIdMapper idMapper : this.ids.values()) {
            idMapper.mapToMapFromEntity(data, obj);
        }
    }

    @Override
    public void mapToMapFromEntity(Map<String, Object> data, Object obj) {
        this.mapToMapFromId(data, obj);
    }

    @Override
    public void mapToEntityFromMap(Object obj, Map data) {
        for (SingleIdMapper idMapper : this.ids.values()) {
            idMapper.mapToEntityFromMap(obj, data);
        }
    }

    @Override
    public IdMapper prefixMappedProperties(String prefix) {
        MultipleIdMapper ret = new MultipleIdMapper(this.compositeIdClass);
        for (String propertyName : this.ids.keySet()) {
            ret.ids.put(propertyName, new SingleIdMapper(propertyName, prefix + propertyName));
        }
        return ret;
    }

    @Override
    public Object mapToIdFromEntity(Object data) {
        Object ret;
        if (data == null) {
            return null;
        }
        try {
            ret = Thread.currentThread().getContextClassLoader().loadClass(this.compositeIdClass).newInstance();
        }
        catch (Exception e) {
            throw new VersionsException(e);
        }
        for (SingleIdMapper mapper : this.ids.values()) {
            mapper.mapToEntityFromEntity(ret, data);
        }
        return ret;
    }

    @Override
    public List<QueryParameterData> mapToQueryParametersFromId(Object obj) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        this.mapToMapFromId(data, obj);
        ArrayList<QueryParameterData> ret = new ArrayList<QueryParameterData>();
        for (String propertyName : data.keySet()) {
            ret.add(new QueryParameterData(propertyName, data.get(propertyName)));
        }
        return ret;
    }
}

