/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.property.Getter;
import org.hibernate.property.Setter;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.mapper.PropertyMapper;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.CollectionProxy;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.Initializor;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.ListProxy;
import org.jboss.envers.entities.mapper.relation.lazy.proxy.SetProxy;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.tools.reflection.ReflectionTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOneToManyMapper
implements PropertyMapper {
    private final String owningEntityName;
    private final String propertyName;

    protected AbstractOneToManyMapper(String owningEntityName, String propertyName) {
        this.owningEntityName = owningEntityName;
        this.propertyName = propertyName;
    }

    protected abstract <T extends Collection> Initializor<T> getInitializator(VersionsConfiguration var1, VersionsReaderImplementor var2, Class<?> var3, Object var4, Number var5, Class<T> var6);

    @Override
    public void mapToEntityFromMap(VersionsConfiguration verCfg, Object obj, Map data, Object primaryKey, VersionsReaderImplementor versionsReader, Number revision) {
        CollectionProxy value;
        if (obj == null) {
            return;
        }
        Class<?> entityClass = ReflectionTools.loadClass(this.owningEntityName);
        Getter getter = ReflectionTools.getGetter(obj.getClass(), this.propertyName);
        Class collectionClass = getter.getReturnType();
        if (List.class.isAssignableFrom(collectionClass)) {
            value = new ListProxy(this.getInitializator(verCfg, versionsReader, entityClass, primaryKey, revision, ArrayList.class));
        } else if (Set.class.isAssignableFrom(collectionClass) || Collection.class.isAssignableFrom(collectionClass)) {
            value = new SetProxy(this.getInitializator(verCfg, versionsReader, entityClass, primaryKey, revision, HashSet.class));
        } else {
            throw new VersionsException("Unsupported versioned collection type: " + collectionClass.getName());
        }
        Setter setter = ReflectionTools.getSetter(obj.getClass(), this.propertyName);
        setter.set(obj, value, null);
    }
}

