/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.entities.mapper.relation;

import org.hibernate.Query;
import org.jboss.envers.RevisionType;
import org.jboss.envers.configuration.VersionsEntitiesConfiguration;
import org.jboss.envers.entities.mapper.id.IdMapper;
import org.jboss.envers.entities.mapper.id.QueryParameterData;
import org.jboss.envers.reader.VersionsReaderImplementor;

public class DetachedRelationQueryGenerator {
    private final String queryString;
    private final IdMapper referencingMiddleIdMapper;

    public DetachedRelationQueryGenerator(VersionsEntitiesConfiguration verEntCfg, String versionsReferencedEntityName, String versionsMiddleEntityName, IdMapper referencingMiddleIdMapper, IdMapper referencedMiddleIdMapper, IdMapper referencedIdMapper) {
        this.referencingMiddleIdMapper = referencingMiddleIdMapper;
        String revisionPropertyPath = verEntCfg.getRevisionPropPath();
        String originalIdPropertyName = verEntCfg.getOriginalIdPropName();
        StringBuilder querySB = new StringBuilder();
        querySB.append("SELECT e FROM ").append(versionsReferencedEntityName).append(" e").append(", ").append(versionsMiddleEntityName).append(" ee ").append("WHERE ").append("e.").append(revisionPropertyPath).append(" = (SELECT max(e2.").append(revisionPropertyPath).append(") FROM ").append(versionsReferencedEntityName).append(" e2 ").append("WHERE e2.").append(revisionPropertyPath).append(" <= :revision AND ").append(referencedIdMapper.getIdsEqualQuery("e." + originalIdPropertyName, "e2." + originalIdPropertyName)).append(") AND ").append(referencedMiddleIdMapper.getIdsEqualQuery("ee." + originalIdPropertyName, referencedIdMapper, "e." + originalIdPropertyName)).append(" AND ").append(referencingMiddleIdMapper.getIdEqualsQuery("ee." + originalIdPropertyName, true)).append(" AND ").append("ee.").append(revisionPropertyPath).append(" = (SELECT max(ee2.").append(revisionPropertyPath).append(") FROM ").append(versionsMiddleEntityName).append(" ee2 ").append("WHERE ee2.").append(revisionPropertyPath).append(" <= :revision AND ").append(referencingMiddleIdMapper.getIdEqualsQuery("ee2." + originalIdPropertyName, true)).append(" AND ").append(referencedMiddleIdMapper.getIdsEqualQuery("ee." + originalIdPropertyName, "ee2." + originalIdPropertyName)).append(") AND ").append("e.").append(verEntCfg.getRevisionTypePropName()).append(" != ").append(":delrevisiontype").append(" AND ").append("ee.").append(verEntCfg.getRevisionTypePropName()).append(" != ").append(":delrevisiontype");
        this.queryString = querySB.toString();
    }

    public Query getQuery(VersionsReaderImplementor versionsReader, Object primaryKey, Number revision) {
        Query query = versionsReader.getSession().createQuery(this.queryString);
        query.setParameter("revision", (Object)revision);
        query.setParameter("delrevisiontype", (Object)RevisionType.DEL);
        for (QueryParameterData paramData : this.referencingMiddleIdMapper.mapToQueryParametersFromId(primaryKey)) {
            paramData.setParameterValue(query);
        }
        return query;
    }
}

