/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.query.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.entities.EntityInstantiator;
import org.jboss.envers.exception.VersionsException;
import org.jboss.envers.query.VersionsQuery;
import org.jboss.envers.query.criteria.VersionsCriterion;
import org.jboss.envers.query.order.VersionsOrder;
import org.jboss.envers.query.projection.VersionsProjection;
import org.jboss.envers.reader.VersionsReaderImplementor;
import org.jboss.envers.tools.Pair;
import org.jboss.envers.tools.Triple;
import org.jboss.envers.tools.query.QueryBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVersionsQuery
implements VersionsQuery {
    protected EntityInstantiator entityInstantiator;
    protected List<VersionsCriterion> criterions;
    protected String entityName;
    protected String versionsEntityName;
    protected QueryBuilder qb;
    protected boolean hasProjection;
    protected boolean hasOrder;
    protected final VersionsConfiguration verCfg;
    private final VersionsReaderImplementor versionsReader;
    private Integer maxResults;
    private Integer firstResult;
    private Boolean cacheable;
    private String cacheRegion;
    private String comment;
    private FlushMode flushMode;
    private CacheMode cacheMode;
    private Integer timeout;
    private LockMode lockMode;

    protected AbstractVersionsQuery(VersionsConfiguration verCfg, VersionsReaderImplementor versionsReader, Class<?> cls) {
        this.verCfg = verCfg;
        this.versionsReader = versionsReader;
        this.criterions = new ArrayList<VersionsCriterion>();
        this.entityInstantiator = new EntityInstantiator(verCfg, versionsReader);
        this.entityName = cls.getName();
        this.versionsEntityName = verCfg.getVerEntCfg().getVersionsEntityName(this.entityName);
        this.qb = new QueryBuilder(this.versionsEntityName, "e");
    }

    protected List buildAndExecuteQuery() {
        StringBuilder querySb = new StringBuilder();
        HashMap<String, Object> queryParamValues = new HashMap<String, Object>();
        this.qb.build(querySb, queryParamValues);
        Query query = this.versionsReader.getSession().createQuery(querySb.toString());
        for (Map.Entry paramValue : queryParamValues.entrySet()) {
            query.setParameter((String)paramValue.getKey(), paramValue.getValue());
        }
        this.setQueryProperties(query);
        return query.list();
    }

    public abstract List list() throws VersionsException;

    @Override
    public List getResultList() throws VersionsException {
        return this.list();
    }

    @Override
    public Object getSingleResult() throws VersionsException, NonUniqueResultException, NoResultException {
        List result = this.list();
        if (result == null || result.size() == 0) {
            throw new NoResultException();
        }
        if (result.size() > 1) {
            throw new NonUniqueResultException();
        }
        return result.get(0);
    }

    @Override
    public VersionsQuery add(VersionsCriterion criterion) {
        this.criterions.add(criterion);
        return this;
    }

    @Override
    public VersionsQuery addProjection(String function, String propertyName) {
        this.hasProjection = true;
        this.qb.addProjection(function, propertyName, false);
        return this;
    }

    @Override
    public VersionsQuery addProjection(VersionsProjection projection) {
        Triple<String, String, Boolean> projectionData = projection.getData(this.verCfg);
        this.hasProjection = true;
        this.qb.addProjection(projectionData.getFirst(), projectionData.getSecond(), projectionData.getThird());
        return this;
    }

    @Override
    public VersionsQuery addOrder(String propertyName, boolean asc) {
        this.hasOrder = true;
        this.qb.addOrder(propertyName, asc);
        return this;
    }

    @Override
    public VersionsQuery addOrder(VersionsOrder order) {
        Pair<String, Boolean> orderData = order.getData(this.verCfg);
        return this.addOrder(orderData.getFirst(), orderData.getSecond());
    }

    @Override
    public VersionsQuery setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public VersionsQuery setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    @Override
    public VersionsQuery setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    @Override
    public VersionsQuery setCacheRegion(String cacheRegion) {
        this.cacheRegion = cacheRegion;
        return this;
    }

    @Override
    public VersionsQuery setComment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public VersionsQuery setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
        return this;
    }

    @Override
    public VersionsQuery setCacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    @Override
    public VersionsQuery setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public VersionsQuery setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    protected void setQueryProperties(Query query) {
        if (this.maxResults != null) {
            query.setMaxResults(this.maxResults.intValue());
        }
        if (this.firstResult != null) {
            query.setFirstResult(this.firstResult.intValue());
        }
        if (this.cacheable != null) {
            query.setCacheable(this.cacheable.booleanValue());
        }
        if (this.cacheRegion != null) {
            query.setCacheRegion(this.cacheRegion);
        }
        if (this.comment != null) {
            query.setComment(this.comment);
        }
        if (this.flushMode != null) {
            query.setFlushMode(this.flushMode);
        }
        if (this.cacheMode != null) {
            query.setCacheMode(this.cacheMode);
        }
        if (this.timeout != null) {
            query.setTimeout(this.timeout.intValue());
        }
        if (this.lockMode != null) {
            query.setLockMode("e", this.lockMode);
        }
    }
}

