/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.synchronization.work;

import java.io.Serializable;
import java.util.HashMap;
import org.hibernate.Session;
import org.jboss.envers.RevisionType;
import org.jboss.envers.configuration.VersionsConfiguration;
import org.jboss.envers.synchronization.work.AbstractVersionsWorkUnit;
import org.jboss.envers.synchronization.work.AddWorkUnit;
import org.jboss.envers.synchronization.work.DelWorkUnit;
import org.jboss.envers.synchronization.work.KeepCheckResult;
import org.jboss.envers.synchronization.work.KeepCheckVisitor;
import org.jboss.envers.synchronization.work.ModWorkUnit;
import org.jboss.envers.synchronization.work.VersionsWorkUnit;

public class CollectionChangeWorkUnit
extends AbstractVersionsWorkUnit
implements VersionsWorkUnit {
    private final Object entity;

    public CollectionChangeWorkUnit(String entityName, VersionsConfiguration verCfg, Serializable id, Object entity) {
        super(entityName, verCfg, id);
        this.entity = entity;
    }

    public boolean containsWork() {
        return true;
    }

    public void perform(Session session, Object revisionData) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        this.fillDataWithId(data, revisionData, RevisionType.MOD);
        this.verCfg.getEntCfg().get(this.getEntityName()).getPropertyMapper().mapToMapFromEntity(data, this.entity, null);
        session.save(this.verCfg.getVerEntCfg().getVersionsEntityName(this.getEntityName()), data);
        this.setPerformed(data);
    }

    public KeepCheckResult check(AddWorkUnit second) {
        return KeepCheckResult.SECOND;
    }

    public KeepCheckResult check(ModWorkUnit second) {
        return KeepCheckResult.SECOND;
    }

    public KeepCheckResult check(DelWorkUnit second) {
        return KeepCheckResult.SECOND;
    }

    public KeepCheckResult check(CollectionChangeWorkUnit second) {
        return KeepCheckResult.FIRST;
    }

    public KeepCheckResult dispatch(KeepCheckVisitor first) {
        return first.check(this);
    }
}

