/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.envers.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class VersionsEntitiesConfiguration {
    private final String versionsTablePrefix;
    private final String versionsTableSuffix;
    private final String originalIdPropName;
    private final String revisionPropName;
    private final String revisionPropType;
    private final String revisionPropPath;
    private final String revisionEntityPath;
    private final String revisionTypePropName;
    private final String revisionTypePropType;
    private final String revisionInfoEntityName;
    private final Map<String, String> customVersionsTablesNames;

    public VersionsEntitiesConfiguration(Properties properties, String revisionPropType, String revisionInfoEntityName) {
        this.revisionInfoEntityName = revisionInfoEntityName;
        this.versionsTablePrefix = properties.getProperty("org.jboss.envers.versionsTablePrefix", "");
        this.versionsTableSuffix = properties.getProperty("org.jboss.envers.versionsTableSuffix", "_versions");
        this.originalIdPropName = "originalId";
        this.revisionPropName = properties.getProperty("org.jboss.envers.revisionFieldName", "_revision");
        this.revisionPropType = revisionPropType;
        this.revisionTypePropName = properties.getProperty("org.jboss.envers.revisionTypeFieldName", "_revision_type");
        this.revisionTypePropType = "byte";
        this.customVersionsTablesNames = new HashMap<String, String>();
        this.revisionEntityPath = this.originalIdPropName + "." + this.revisionPropName;
        this.revisionPropPath = this.revisionEntityPath + ".id";
    }

    public String getOriginalIdPropName() {
        return this.originalIdPropName;
    }

    public String getRevisionPropName() {
        return this.revisionPropName;
    }

    public String getRevisionPropPath() {
        return this.revisionPropPath;
    }

    public String getRevisionPropType() {
        return this.revisionPropType;
    }

    public String getRevisionTypePropName() {
        return this.revisionTypePropName;
    }

    public String getRevisionTypePropType() {
        return this.revisionTypePropType;
    }

    public String getRevisionEntityPath() {
        return this.revisionEntityPath;
    }

    public String getRevisionInfoEntityName() {
        return this.revisionInfoEntityName;
    }

    public void addCustomVersionsTableName(String entityName, String tableName) {
        this.customVersionsTablesNames.put(entityName, tableName);
    }

    public String getVersionsEntityName(String entityName) {
        return this.versionsTablePrefix + entityName + this.versionsTableSuffix;
    }

    public boolean isVersionsEntityName(String entityName) {
        if (entityName == null) {
            return false;
        }
        return entityName.endsWith(this.versionsTableSuffix) && entityName.startsWith(this.versionsTablePrefix);
    }

    public String getVersionsTableName(String entityName, String tableName) {
        String customHistoryTableName = this.customVersionsTablesNames.get(entityName);
        if (customHistoryTableName == null) {
            return this.versionsTablePrefix + tableName + this.versionsTableSuffix;
        }
        return customHistoryTableName;
    }
}

